/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.annotations.NotNull;
import com.alee.extended.accordion.AccordionAdapter;
import com.alee.extended.accordion.AccordionListener;
import com.alee.extended.accordion.AccordionPane;
import com.alee.extended.accordion.AccordionState;
import com.alee.extended.accordion.WebAccordion;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;

public class AccordionSettingsProcessor
extends SettingsProcessor<WebAccordion, AccordionState, Configuration<AccordionState>> {
    protected transient AccordionListener accordionListener;

    public AccordionSettingsProcessor(@NotNull WebAccordion accordion, @NotNull Configuration configuration) {
        super(accordion, configuration);
    }

    @Override
    protected void register(@NotNull WebAccordion accordion) {
        this.accordionListener = new AccordionAdapter(){

            @Override
            public void expanding(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
                AccordionSettingsProcessor.this.save();
            }

            @Override
            public void collapsing(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
                AccordionSettingsProcessor.this.save();
            }
        };
        accordion.addAccordionListener(this.accordionListener);
    }

    @Override
    protected void unregister(@NotNull WebAccordion accordion) {
        accordion.removeAccordionListener(this.accordionListener);
        this.accordionListener = null;
    }

    @Override
    protected void loadSettings(@NotNull WebAccordion accordion) {
        AccordionState state = (AccordionState)this.loadSettings();
        if (state != null) {
            accordion.setAccordionState(state);
        }
    }

    @Override
    protected void saveSettings(@NotNull WebAccordion accordion) {
        this.saveSettings(accordion.getAccordionState());
    }
}

