/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.api.merge.Mergeable;
import com.alee.extended.accordion.AccordionPane;
import com.alee.extended.layout.AbstractLayoutManager;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;

@XStreamAlias(value="AccordionPaneLayout")
public class AccordionPaneLayout
extends AbstractLayoutManager
implements Mergeable,
Cloneable,
Serializable {
    @Nullable
    protected Boolean fitHeader;

    public AccordionPaneLayout() {
        this(true);
    }

    public AccordionPaneLayout(boolean fitHeader) {
        this.setFitHeader(fitHeader);
    }

    public boolean isFitHeader() {
        return this.fitHeader == null || this.fitHeader != false;
    }

    public void setFitHeader(boolean fitHeader) {
        this.fitHeader = fitHeader;
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        AccordionPane pane = (AccordionPane)parent;
        JComponent header = pane.getHeader();
        Insets insets = pane.getInsets();
        int availableWidth = pane.getWidth() - insets.left - insets.right;
        int availableHeight = pane.getHeight() - insets.top - insets.bottom;
        Rectangle bounds = new Rectangle(insets.left, insets.top, availableWidth, availableHeight);
        boolean ltr = pane.getComponentOrientation().isLeftToRight();
        BoxOrientation position = pane.getHeaderPosition();
        Dimension hps = ((Component)header).getPreferredSize();
        int x = position.isTop() || position.isBottom() || (ltr ? position.isLeft() : position.isRight()) ? bounds.x : bounds.x + bounds.width - Math.min(availableWidth, hps.width);
        int y = position.isTop() || position.isLeft() || position.isRight() ? bounds.y : bounds.y + bounds.height - Math.min(availableHeight, hps.height);
        int w = position.isTop() || position.isBottom() ? availableWidth : Math.min(availableWidth, hps.width);
        int h = position.isLeft() || position.isRight() ? availableHeight : Math.min(availableHeight, hps.height);
        header.setBounds(x, y, w, h);
        Component content = pane.getContent();
        if (content != null) {
            if (position.isTop()) {
                bounds.y += h;
                bounds.height -= h;
            } else if (position.isBottom()) {
                bounds.height -= h;
            } else if (ltr && position.isLeft() || !ltr && position.isRight()) {
                bounds.x += w;
                bounds.width -= w;
            } else {
                bounds.width -= w;
            }
            content.setBounds(bounds);
            content.setVisible(bounds.width > 0 && bounds.height > 0);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        AccordionPane pane = (AccordionPane)parent;
        JComponent header = pane.getHeader();
        Component content = pane.getContent();
        BoxOrientation position = pane.getHeaderPosition();
        boolean vertical = position.isTop() || position.isBottom();
        Insets insets = pane.getInsets();
        Dimension ps = new Dimension(0, 0);
        Dimension cps = content != null ? content.getPreferredSize() : new Dimension();
        ps.width = vertical ? cps.width : 0;
        ps.height = vertical ? 0 : cps.height;
        Dimension hps = ((Component)header).getPreferredSize();
        if (vertical) {
            if (this.isFitHeader()) {
                ps.width = Math.max(ps.width, hps.width);
            }
            ps.height += hps.height;
        } else {
            if (this.isFitHeader()) {
                ps.height = Math.max(ps.height, hps.height);
            }
            ps.width += hps.width;
        }
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    @XStreamAlias(value="AccordionPaneLayout$UIResource")
    public static final class UIResource
    extends AccordionPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

