/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.resource;

import com.alee.api.annotations.NotNull;
import com.alee.api.resource.Resource;
import com.alee.api.resource.ResourceException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

@XStreamAlias(value="FileResource")
public final class FileResource
implements Resource {
    @XStreamAsAttribute
    @NotNull
    private final String path;

    public FileResource(@NotNull File file) {
        this(file.getAbsolutePath());
    }

    public FileResource(@NotNull String path) {
        this.path = path;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.path);
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("Unable to open FileResource stream for path: " + this.path, e);
        }
    }
}

