/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.resource;

import com.alee.api.annotations.NotNull;
import com.alee.api.resource.Resource;
import com.alee.api.resource.ResourceException;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.InputStream;

@XStreamAlias(value="ClassResource")
public final class ClassResource
implements Resource {
    @XStreamAsAttribute
    @NotNull
    private final String className;
    @XStreamAsAttribute
    @NotNull
    private final String path;

    public ClassResource(@NotNull Class<?> clazz, @NotNull String path) {
        this(clazz.getCanonicalName(), path);
    }

    public ClassResource(@NotNull String className, @NotNull String path) {
        this.className = className;
        this.path = path;
    }

    @NotNull
    public String getClassName() {
        return this.className;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        try {
            return ReflectUtils.getClass(this.className).getResourceAsStream(this.path);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceException("Unable to open ClassResource stream for class and path: " + this.className + ":" + this.path, e);
        }
    }
}

