/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.RecursiveMerge;
import com.alee.utils.ReflectUtils;
import java.lang.reflect.Array;

public class IndexArrayMergeBehavior
implements GlobalMergeBehavior<Object, Object, Object> {
    @Override
    public boolean supports(@NotNull RecursiveMerge merge, @NotNull Class<Object> type, @NotNull Object base, @NotNull Object merged) {
        return base.getClass().isArray() && merged.getClass().isArray();
    }

    @Override
    @NotNull
    public Object merge(@NotNull RecursiveMerge merge, @NotNull Class type, @NotNull Object base, @NotNull Object merged, int depth) {
        Class<?> mergedType;
        int el = Array.getLength(base);
        int ml = Array.getLength(merged);
        int rl = Math.max(el, ml);
        Class baseType = base.getClass().getComponentType();
        Class resultingType = baseType == (mergedType = merged.getClass().getComponentType()) ? baseType : ReflectUtils.getClosestSuperclass(baseType, mergedType);
        Object result2 = baseType == mergedType && el >= ml ? base : Array.newInstance(resultingType, rl);
        for (int i = 0; i < rl; ++i) {
            Object ev;
            if (i < el && i < ml) {
                ev = Array.get(base, i);
                Object mv = Array.get(merged, i);
                Array.set(result2, i, merge.merge(resultingType, ev, mv, depth + 1));
                continue;
            }
            if (i < el) {
                ev = Array.get(base, i);
                Array.set(result2, i, ev);
                continue;
            }
            Object mv = Array.get(merged, i);
            Array.set(result2, i, mv);
        }
        return result2;
    }
}

