/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.jdk;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Supplier;
import com.alee.managers.language.LM;
import com.alee.utils.UtilityException;
import java.util.Arrays;

public final class Objects {
    private Objects() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static int hash(Object ... values2) {
        return Arrays.hashCode(values2);
    }

    public static boolean equals(@Nullable Object object, @Nullable Object compareWith) {
        return object == compareWith || object != null && object.equals(compareWith);
    }

    public static boolean equals(@Nullable Object object, Object ... compareWith) {
        boolean equals = false;
        if (compareWith != null && compareWith.length > 0) {
            for (Object o : compareWith) {
                if (!Objects.equalsImpl(object, o)) continue;
                equals = true;
                break;
            }
        }
        return equals;
    }

    public static boolean notEquals(@Nullable Object object, @Nullable Object compareWith) {
        return object != compareWith && (object == null || !object.equals(compareWith));
    }

    public static boolean notEquals(@Nullable Object object, Object ... compareWith) {
        boolean notEquals = true;
        if (compareWith != null && compareWith.length > 0) {
            for (Object o : compareWith) {
                if (!Objects.equalsImpl(object, o)) continue;
                notEquals = false;
                break;
            }
        }
        return notEquals;
    }

    private static boolean equalsImpl(@Nullable Object o1, @Nullable Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    @NotNull
    public static <T> T requireNonNull(@Nullable T object) {
        return Objects.requireNonNull(object, "Object must not be null");
    }

    @NotNull
    public static <T> T requireNonNull(@Nullable T object, @NotNull String message) {
        if (object == null) {
            throw new NullPointerException(LM.contains(message) ? LM.get(message, new Object[0]) : message);
        }
        return object;
    }

    @NotNull
    public static <T> T requireNonNull(@Nullable T object, @NotNull Supplier<RuntimeException> exceptionSupplier) {
        if (object == null) {
            throw exceptionSupplier.get();
        }
        return object;
    }
}

