/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.duplicate;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.duplicate.DuplicateResolver;
import com.alee.api.matcher.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractDuplicateResolver
implements DuplicateResolver {
    @NotNull
    private final Matcher matcher;

    public AbstractDuplicateResolver(@NotNull Matcher matcher) {
        this.matcher = matcher;
    }

    protected boolean hasDuplicates(@NotNull Collection collection) {
        boolean hasDuplicates = false;
        ArrayList checked = new ArrayList(collection.size());
        for (Object next : collection) {
            if (this.matcher.supports(next)) {
                for (Object previous : checked) {
                    if (!this.matcher.supports(previous) || !this.matcher.match(previous, next)) continue;
                    hasDuplicates = true;
                    break;
                }
                if (hasDuplicates) break;
            }
            checked.add(next);
        }
        return hasDuplicates;
    }

    @Nullable
    protected Object firstDuplicate(@NotNull Collection collection) {
        Object duplicate = null;
        boolean found = false;
        ArrayList checked = new ArrayList(collection.size());
        for (Object next : collection) {
            if (this.matcher.supports(next)) {
                for (Object previous : checked) {
                    if (!this.matcher.supports(previous) || !this.matcher.match(previous, next)) continue;
                    duplicate = next;
                    found = true;
                    break;
                }
                if (found) break;
            }
            checked.add(next);
        }
        return duplicate;
    }

    @NotNull
    protected Collection removeDuplicates(@NotNull Collection collection) {
        ArrayList checked = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            boolean unique = true;
            if (this.matcher.supports(next)) {
                for (Object previous : checked) {
                    if (!this.matcher.supports(previous) || !this.matcher.match(previous, next)) continue;
                    unique = false;
                    iterator.remove();
                    break;
                }
            }
            if (!unique) continue;
            checked.add(next);
        }
        return collection;
    }
}

