/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.clone.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.clone.CloneException;
import com.alee.api.clone.GlobalCloneBehavior;
import com.alee.api.clone.RecursiveClone;
import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.ImmutableCollection;
import com.alee.utils.collection.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;

public class CollectionCloneBehavior
implements GlobalCloneBehavior<Collection> {
    @Override
    public boolean supports(@NotNull RecursiveClone clone, @NotNull Object object) {
        return object instanceof Collection;
    }

    @Override
    @NotNull
    public Collection clone(@NotNull RecursiveClone clone, @NotNull Collection collection, int depth) {
        try {
            Class<?> collectionClass = collection.getClass();
            Collection collectionCopy = collectionClass == ImmutableCollection.class || collectionClass == ImmutableList.class || collectionClass == ArrayList.class || collectionClass.getCanonicalName().equals("java.util.Collections.SingletonList") ? new ArrayList(collection.size()) : (collectionClass == LinkedList.class ? new LinkedList() : (collectionClass == Vector.class ? new Vector(collection.size()) : (Collection)ReflectUtils.createInstance(collectionClass, new Object[0])));
            if (!collection.isEmpty()) {
                clone.store(collection, collectionCopy);
                for (Object element : collection) {
                    Object valueCopy = clone.clone(element, depth + 1);
                    collectionCopy.add(valueCopy);
                }
            }
            Collection result2 = collection instanceof ImmutableCollection ? new ImmutableCollection(collectionCopy) : (collection instanceof ImmutableList ? new ImmutableList(collectionCopy) : (collectionClass.getCanonicalName().equals("java.util.Collections.SingletonList") ? Collections.singletonList(collectionCopy.iterator().next()) : collectionCopy));
            return result2;
        }
        catch (Exception e) {
            throw new CloneException("Unable to clone collection: " + collection, e);
        }
    }

    @Override
    public boolean isStorable() {
        return true;
    }
}

