/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.DoubleLinkedList;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.RecencyList;
import akka.util.SegmentedRecencyList$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}uAB%K\u0011\u0003aeJ\u0002\u0004Q\u0015\"\u0005A*\u0015\u0005\u00061\u0006!\tA\u0017\u0005\u00067\u0006!\t\u0001X\u0004\b\u0005\u000b\u000b\u0001\u0012\u0001BD\r\u001d\u0011I)\u0001E\u0001\u0005\u0017Ca\u0001W\u0003\u0005\u0002\t5\u0005BB.\u0006\t\u0003\u0011yI\u0002\u0004\u0002R\u00051\u00111\u000b\u0005\u000b\u0003/B!Q1A\u0005\u0002\u0005e\u0003BCA0\u0011\t\u0005\t\u0015!\u0003\u0002\\!1\u0001\f\u0003C\u0001\u0003CB\u0011\"!\u001b\t\u0001\u0004%\t!a\u000b\t\u0013\u0005-\u0004\u00021A\u0005\u0002\u00055\u0004bBA9\u0011\u0001\u0006KA\u001b\u0005\n\u0003gB\u0001\u0019!C\u0001\u0003kB\u0011\"! \t\u0001\u0004%\t!a \t\u0011\u0005\r\u0005\u0002)Q\u0005\u0003oB\u0011\"!\"\t\u0001\u0004%\t!a\"\t\u0013\u0005-\u0005\u00021A\u0005\u0002\u00055\u0005\u0002CAI\u0011\u0001\u0006K!!#\t\u0013\u0005M\u0005\u00021A\u0005\u0002\u0005\u001d\u0005\"CAK\u0011\u0001\u0007I\u0011AAL\u0011!\tY\n\u0003Q!\n\u0005%\u0005\"CAO\u0011\u0001\u0007I\u0011AAD\u0011%\ty\n\u0003a\u0001\n\u0003\t\t\u000b\u0003\u0005\u0002&\"\u0001\u000b\u0015BAE\u0011%\t9\u000b\u0003a\u0001\n\u0003\t9\tC\u0005\u0002*\"\u0001\r\u0011\"\u0001\u0002,\"A\u0011q\u0016\u0005!B\u0013\tIIB\u0003Q\u0015\nau\f\u0003\u0005b=\t\u0005\t\u0015!\u0003c\u0011!igD!A!\u0002\u0013q\u0007\"\u0002-\u001f\t\u0003A\b\"CA\b=\u0001\u0007I\u0011BA\t\u0011%\tIB\ba\u0001\n\u0013\tY\u0002\u0003\u0005\u0002(y\u0001\u000b\u0015BA\n\u0011%\tIC\ba\u0001\n\u0013\tY\u0003C\u0005\u0002.y\u0001\r\u0011\"\u0003\u00020!9\u00111\u0007\u0010!B\u0013Q\u0007\"CA\u001b=\t\u0007I\u0011BA\u0016\u0011\u001d\t9D\bQ\u0001\n)D\u0011\"!\u000f\u001f\u0005\u0004%I!a\u000b\t\u000f\u0005mb\u0004)A\u0005U\"I\u0011Q\b\u0010C\u0002\u0013%\u00111\u0006\u0005\b\u0003\u007fq\u0002\u0015!\u0003k\u0011%\t\tE\bb\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u00022z\u0001\u000b\u0011BA#\u0011%\t\u0019L\bb\u0001\n\u0013\t)\f\u0003\u0005\u0002Bz\u0001\u000b\u0011BA\\\u0011%\t\u0019M\bb\u0001\n\u0013\t)\r\u0003\u0005\u0002Hz\u0001\u000b\u0011BA$\u0011%\tIM\bb\u0001\n\u0013\tY\r\u0003\u0005\u0002Tz\u0001\u000b\u0011BAg\u0011\u001d\t)N\bC\u0001\u0003WAq!a6\u001f\t\u0003\tI\u000eC\u0004\u0002^z!\t!a8\t\u000f\u0005\rh\u0004\"\u0001\u0002f\"9\u0011\u0011\u001e\u0010\u0005\u0002\u0005-\bbBA{=\u0011\u0005\u0011q\u001f\u0005\b\u0003wtB\u0011AA\u007f\u0011\u001d\u0011IB\bC\u0001\u00057AqAa\b\u001f\t\u0003\u0011Y\u0002C\u0004\u0003\"y!\tAa\t\t\u000f\t]b\u0004\"\u0001\u0003:!9!q\b\u0010\u0005\n\t\u0005\u0003b\u0002B\"=\u0011%!Q\t\u0005\b\u0005\u0013rB\u0011\u0002B&\u0011\u001d\u0011\tF\bC\u0005\u0005'BqAa\u0016\u001f\t\u0013\u0011I\u0006C\u0004\u0003^y!IAa\u0018\t\u000f\t\u0015d\u0004\"\u0003\u0003h!9!1\u000e\u0010\u0005\n\t5\u0014\u0001F*fO6,g\u000e^3e%\u0016\u001cWM\\2z\u0019&\u001cHO\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\u0005i\u0015\u0001B1lW\u0006\u0004\"aT\u0001\u000e\u0003)\u0013AcU3h[\u0016tG/\u001a3SK\u000e,gnY=MSN$8CA\u0001S!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001O\u0003\u0015)W\u000e\u001d;z+\ri&\u0011\u0011\u000b\u0004=\n\r\u0005\u0003B(\u001f\u0005\u007f*\"\u0001\u0019?\u0014\u0005y\u0011\u0016!D5oSRL\u0017\r\u001c'j[&$8\u000fE\u0002dQ*l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001d$\u0016AC2pY2,7\r^5p]&\u0011\u0011\u000e\u001a\u0002\u0004'\u0016\f\bCA*l\u0013\taGKA\u0002J]R\fQa\u00197pG.\u00042aT8r\u0013\t\u0001(JA\u0005PaRLwN\u001c,bYB\u0011!/\u001e\b\u0003\u001fNL!\u0001\u001e&\u0002\u0017I+7-\u001a8ds2K7\u000f^\u0005\u0003m^\u0014Qa\u00117pG.T!\u0001\u001e&\u0015\u000be\fY!!\u0004\u0011\u0007=s\"\u0010\u0005\u0002|y2\u0001A!B?\u001f\u0005\u0004q(!A!\u0012\u0007}\f)\u0001E\u0002T\u0003\u0003I1!a\u0001U\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aUA\u0004\u0013\r\tI\u0001\u0016\u0002\u0004\u0003:L\b\"B1\"\u0001\u0004\u0011\u0007\"B7\"\u0001\u0004q\u0017A\u00027j[&$8/\u0006\u0002\u0002\u0014A!1-!\u0006k\u0013\r\t9\u0002\u001a\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018A\u00037j[&$8o\u0018\u0013fcR!\u0011QDA\u0012!\r\u0019\u0016qD\u0005\u0004\u0003C!&\u0001B+oSRD\u0011\"!\n$\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\u0004mS6LGo\u001d\u0011\u0002\u0015Q|G/\u00197MS6LG/F\u0001k\u00039!x\u000e^1m\u0019&l\u0017\u000e^0%KF$B!!\b\u00022!A\u0011Q\u0005\u0014\u0002\u0002\u0003\u0007!.A\u0006u_R\fG\u000eT5nSR\u0004\u0013A\u00027fm\u0016d7/A\u0004mKZ,Gn\u001d\u0011\u0002\r1|w/Z:u\u0003\u001dawn^3ti\u0002\nq\u0001[5hQ\u0016\u001cH/\u0001\u0005iS\u001eDWm\u001d;!\u0003!\u0019XmZ7f]R\u001cXCAA#!\u0015\u0019\u0017QCA$!\u0015y\u0015\u0011JA'\u0013\r\tYE\u0013\u0002\u0011\t>,(\r\\3MS:\\W\r\u001a'jgR\u0004B!a\u0014\tu:\u0011q\n\u0001\u0002\u0005\u001d>$W-\u0006\u0003\u0002V\u0005u3C\u0001\u0005S\u0003\u00151\u0018\r\\;f+\t\tY\u0006E\u0002|\u0003;\"Q! \u0005C\u0002y\faA^1mk\u0016\u0004C\u0003BA2\u0003O\u0002R!!\u001a\t\u00037j\u0011!\u0001\u0005\b\u0003/Z\u0001\u0019AA.\u0003\u0015aWM^3m\u0003%aWM^3m?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005=\u0004\u0002CA\u0013\u001b\u0005\u0005\t\u0019\u00016\u0002\r1,g/\u001a7!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0006\u0002\u0002xA\u00191+!\u001f\n\u0007\u0005mDK\u0001\u0003M_:<\u0017!\u0004;j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005\u0005\u0005\"CA\u0013!\u0005\u0005\t\u0019AA<\u0003)!\u0018.\\3ti\u0006l\u0007\u000fI\u0001\u000bY\u0016\u001c8OU3dK:$XCAAE!\u0011yu.a\u0019\u0002\u001d1,7o\u001d*fG\u0016tGo\u0018\u0013fcR!\u0011QDAH\u0011%\t)cEA\u0001\u0002\u0004\tI)A\u0006mKN\u001c(+Z2f]R\u0004\u0013AC7pe\u0016\u0014VmY3oi\u0006qQn\u001c:f%\u0016\u001cWM\u001c;`I\u0015\fH\u0003BA\u000f\u00033C\u0011\"!\n\u0017\u0003\u0003\u0005\r!!#\u0002\u00175|'/\u001a*fG\u0016tG\u000fI\u0001\u0012_Z,'/\u00197m\u0019\u0016\u001c8OU3dK:$\u0018!F8wKJ\fG\u000e\u001c'fgN\u0014VmY3oi~#S-\u001d\u000b\u0005\u0003;\t\u0019\u000bC\u0005\u0002&e\t\t\u00111\u0001\u0002\n\u0006\u0011rN^3sC2dG*Z:t%\u0016\u001cWM\u001c;!\u0003Eyg/\u001a:bY2luN]3SK\u000e,g\u000e^\u0001\u0016_Z,'/\u00197m\u001b>\u0014XMU3dK:$x\fJ3r)\u0011\ti\"!,\t\u0013\u0005\u0015B$!AA\u0002\u0005%\u0015AE8wKJ\fG\u000e\\'pe\u0016\u0014VmY3oi\u0002\n\u0011b]3h[\u0016tGo\u001d\u0011\u0002\u000bML'0Z:\u0016\u0005\u0005]\u0006#BA]\u0003\u007fSWBAA^\u0015\r\tiLZ\u0001\b[V$\u0018M\u00197f\u0013\u0011\t9\"a/\u0002\rML'0Z:!\u00039yg/\u001a:bY2\u0014VmY3oGf,\"!a\u0012\u0002\u001f=4XM]1mYJ+7-\u001a8ds\u0002\n!\u0002\\8pWV\u0004hj\u001c3f+\t\ti\rE\u0004\u0002:\u0006='0!\u0014\n\t\u0005E\u00171\u0018\u0002\u0004\u001b\u0006\u0004\u0018a\u00037p_.,\bOT8eK\u0002\nAa]5{K\u000611/\u001b>f\u001f\u001a$2A[An\u0011\u0019\tIg\u000ea\u0001U\u00061Q\u000f\u001d3bi\u0016$2!_Aq\u0011\u0019\t9\u0006\u000fa\u0001u\u00061!/Z7pm\u0016$2!_At\u0011\u0019\t9&\u000fa\u0001u\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0002n\u0006M\bcA*\u0002p&\u0019\u0011\u0011\u001f+\u0003\u000f\t{w\u000e\\3b]\"1\u0011q\u000b\u001eA\u0002i\f1\u0002\\3bgR\u0014VmY3oiV\u0011\u0011\u0011 \t\u0004\u001f>T\u0018a\u00057fCN$Hk\\'pgR\u0014VmY3oi>3G\u0003BA\u0000\u0005/\u0001RA!\u0001\u0003\u0012itAAa\u0001\u0003\u000e9!!Q\u0001B\u0006\u001b\t\u00119AC\u0002\u0003\ne\u000ba\u0001\u0010:p_Rt\u0014\"A+\n\u0007\t=A+A\u0004qC\u000e\\\u0017mZ3\n\t\tM!Q\u0003\u0002\t\u0013R,'/\u0019;pe*\u0019!q\u0002+\t\r\u0005%D\b1\u0001k\u0003i\u0011X-\\8wK2+\u0017m\u001d;SK\u000e,g\u000e^(wKJd\u0015.\\5u)\t\u0011i\u0002E\u0002dQj\f\u0011C]3n_Z,G*Z1tiJ+7-\u001a8u\u0003}\u0011X-\\8wK>3XM]1mY2+\u0017m\u001d;SK\u000e,g\u000e^(viNLG-\u001a\u000b\u0005\u0005;\u0011)\u0003C\u0004\u0003(}\u0002\rA!\u000b\u0002\u0011\u0011,(/\u0019;j_:\u0004BAa\u000b\u000345\u0011!Q\u0006\u0006\u0005\u0005O\u0011yCC\u0002\u00032Q\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011)D!\f\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006aQ\u000f\u001d3bi\u0016d\u0015.\\5ugR!\u0011Q\u0004B\u001e\u0011\u0019\u0011i\u0004\u0011a\u0001E\u0006Ia.Z<MS6LGo]\u0001\u0016C\u0012TWo\u001d;Qe>$Xm\u0019;fI2+g/\u001a7t)\t\ti\"\u0001\u0004bI*,8\u000f\u001e\u000b\u0005\u0003;\u00119\u0005\u0003\u0004\u0002j\t\u0003\rA[\u0001\u0007S:\u001cXM\u001d;\u0015\t\u0005u!Q\n\u0005\b\u0005\u001f\u001a\u0005\u0019AA'\u0003\u0011qw\u000eZ3\u0002\u000fA\u0014x.\\8uKR!\u0011Q\u0004B+\u0011\u001d\u0011y\u0005\u0012a\u0001\u0003\u001b\na\u0001Z3n_R,G\u0003BA\u000f\u00057BqAa\u0014F\u0001\u0004\ti%\u0001\u0005baB,g\u000e\u001a+p)\u0019\tiB!\u0019\u0003d!1\u0011\u0011\u000e$A\u0002)DqAa\u0014G\u0001\u0004\ti%\u0001\fsK6|g/\u001a$s_6\u001cUO\u001d:f]RdUM^3m)\u0011\tiB!\u001b\t\u000f\t=s\t1\u0001\u0002N\u0005Q!/Z7pm\u0016tu\u000eZ3\u0015\u0007i\u0014y\u0007C\u0004\u0003P!\u0003\r!!\u0014)\u0007y\u0011\u0019\b\u0005\u0003\u0003v\tmTB\u0001B<\u0015\r\u0011I\bT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B?\u0005o\u00121\"\u00138uKJt\u0017\r\\!qSB\u00191P!!\u0005\u000bu\u001c!\u0019\u0001@\t\r\u0005=1\u00011\u0001c\u0003I9\u0018\u000e\u001e5Pm\u0016\u0014\u0018\r\u001c7SK\u000e,gnY=\u0011\u0007\u0005\u0015TA\u0001\nxSRDwJ^3sC2d'+Z2f]\u000eL8CA\u0003S)\t\u00119)\u0006\u0003\u0003\u0012\n]E\u0003\u0002BJ\u00053\u0003Ba\u0014\u0010\u0003\u0016B\u00191Pa&\u0005\u000bu<!\u0019\u0001@\t\r\u0005=q\u00011\u0001cQ\r\t!1\u000f\u0015\u0004\u0001\tM\u0004")
@InternalApi
public final class SegmentedRecencyList<A> {
    private final RecencyList.Clock clock;
    private scala.collection.immutable.IndexedSeq<Object> limits;
    private int totalLimit;
    private final int levels;
    private final int lowest;
    private final int highest;
    private final scala.collection.immutable.IndexedSeq<DoubleLinkedList<Node<A>>> segments;
    private final IndexedSeq<Object> sizes;
    private final DoubleLinkedList<Node<A>> overallRecency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> SegmentedRecencyList<A> empty(Seq<Object> limits) {
        return SegmentedRecencyList$.MODULE$.empty(limits);
    }

    private scala.collection.immutable.IndexedSeq<Object> limits() {
        return this.limits;
    }

    private void limits_$eq(scala.collection.immutable.IndexedSeq<Object> x$1) {
        this.limits = x$1;
    }

    private int totalLimit() {
        return this.totalLimit;
    }

    private void totalLimit_$eq(int x$1) {
        this.totalLimit = x$1;
    }

    private int levels() {
        return this.levels;
    }

    private int lowest() {
        return this.lowest;
    }

    private int highest() {
        return this.highest;
    }

    private scala.collection.immutable.IndexedSeq<DoubleLinkedList<Node<A>>> segments() {
        return this.segments;
    }

    private IndexedSeq<Object> sizes() {
        return this.sizes;
    }

    private DoubleLinkedList<Node<A>> overallRecency() {
        return this.overallRecency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public int sizeOf(int level) {
        return BoxesRunTime.unboxToInt(this.sizes().apply(level));
    }

    public SegmentedRecencyList<A> update(A value) {
        if (this.lookupNode().contains(value)) {
            this.promote((Node)this.lookupNode().apply(value));
        } else {
            this.insert(new Node<A>(value));
        }
        return this;
    }

    public SegmentedRecencyList<A> remove(A value) {
        BoxedUnit boxedUnit = this.lookupNode().contains(value) ? this.removeNode((Node)this.lookupNode().apply(value)) : BoxedUnit.UNIT;
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public A leastRecent() {
        Object a;
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            a = OptionVal$Some$.MODULE$.apply(first.value());
        } else {
            a = OptionVal$.MODULE$.none();
        }
        return a;
    }

    public Iterator<A> leastToMostRecentOf(int level) {
        return ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().map((Function1<Node, Object> & Serializable)x$5 -> x$5.value());
    }

    public Seq<A> removeLeastRecentOverLimit() {
        Seq<Nothing$> seq;
        if (this.size() > this.totalLimit()) {
            this.adjustProtectedLevels();
            int excess = this.size() - this.totalLimit();
            seq = excess == 1 ? this.removeLeastRecent() : ((DoubleLinkedList)this.segments().apply(this.lowest())).forwardIterator().take(excess).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node)node)).toList();
        } else {
            seq = package$.MODULE$.Nil();
        }
        return seq;
    }

    public Seq<A> removeLeastRecent() {
        Seq<Nothing$> seq;
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            seq = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.removeNode(first)}));
        } else {
            seq = package$.MODULE$.Nil();
        }
        return seq;
    }

    public Seq<A> removeOverallLeastRecentOutside(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled");
        }
        long min = OptionVal$.MODULE$.get$extension(this.clock).earlierTime(duration);
        return this.overallRecency().forwardIterator().takeWhile((Function1<Node, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(SegmentedRecencyList.$anonfun$removeOverallLeastRecentOutside$1(min, x$6))).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public void updateLimits(Seq<Object> newLimits) {
        this.limits_$eq(newLimits.toIndexedSeq());
        this.totalLimit_$eq(BoxesRunTime.unboxToInt(this.limits().sum(Numeric$IntIsIntegral$.MODULE$)));
    }

    private void adjustProtectedLevels() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.highest()), this.lowest()).by(-1).foreach$mVc$sp(level -> this.adjust(level));
    }

    private void adjust(int level) {
        block0: {
            int excess = BoxesRunTime.unboxToInt(this.sizes().apply(level)) - BoxesRunTime.unboxToInt(this.limits().apply(level));
            if (excess <= 0) break block0;
            ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().take(excess).foreach((Function1<Node, Object> & Serializable)node -> {
                this.demote(node);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void insert(Node<A> node) {
        block0: {
            this.appendTo(this.lowest(), node);
            this.lookupNode().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(node.value()), node));
            if (!OptionVal$.MODULE$.isDefined$extension(this.clock)) break block0;
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().append(node);
        }
    }

    private void promote(Node<A> node) {
        block2: {
            Object object;
            if (node.level() == this.highest()) {
                object = ((DoubleLinkedList)this.segments().apply(node.level())).moveToBack(node);
            } else {
                int newLevel = node.level() + 1;
                this.removeFromCurrentLevel(node);
                this.appendTo(newLevel, node);
                this.adjust(newLevel);
                object = BoxedUnit.UNIT;
            }
            if (!OptionVal$.MODULE$.isDefined$extension(this.clock)) break block2;
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().moveToBack(node);
        }
    }

    private void demote(Node<A> node) {
        this.removeFromCurrentLevel(node);
        this.appendTo(node.level() - 1, node);
    }

    private void appendTo(int level, Node<A> node) {
        node.level_$eq(level);
        ((DoubleLinkedList)this.segments().apply(level)).append(node);
        this.sizes().update(level, BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(this.sizes().apply(level)) + 1));
    }

    private void removeFromCurrentLevel(Node<A> node) {
        ((DoubleLinkedList)this.segments().apply(node.level())).remove(node);
        int n = node.level();
        this.sizes().update(n, BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(this.sizes().apply(n)) - 1));
    }

    /*
     * WARNING - void declaration
     */
    private A removeNode(Node<A> node) {
        void var2_2;
        A value = node.value();
        this.removeFromCurrentLevel(node);
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            this.overallRecency().remove(node);
        }
        this.lookupNode().$minus$eq(value);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$removeOverallLeastRecentOutside$1(long min$1, Node x$6) {
        return x$6.timestamp() < min$1;
    }

    public SegmentedRecencyList(Seq<Object> initialLimits, RecencyList.Clock clock) {
        this.clock = clock;
        this.limits = initialLimits.toIndexedSeq();
        this.totalLimit = BoxesRunTime.unboxToInt(this.limits().sum(Numeric$IntIsIntegral$.MODULE$));
        this.levels = this.limits().size();
        this.lowest = 0;
        this.highest = this.levels() - 1;
        this.segments = (scala.collection.immutable.IndexedSeq)package$.MODULE$.IndexedSeq().fill(this.levels(), (Function0<DoubleLinkedList> & Serializable)() -> new DoubleLinkedList((Function1<Node, Object> & Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1<Node, Object> & Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2<Node, Object, Object> & Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2<Node, Object, Object> & Serializable)(node, next) -> {
            node.moreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        }));
        this.sizes = (IndexedSeq)IndexedSeq$.MODULE$.fill(this.levels(), () -> 0);
        this.overallRecency = new DoubleLinkedList((Function1<Node, Object> & Serializable)x$3 -> new OptionVal<Node>(x$3.overallLessRecent()), (Function1<Node, Object> & Serializable)x$4 -> new OptionVal<Node>(x$4.overallMoreRecent()), (Function2<Node, Object, Object> & Serializable)(node, previous) -> {
            node.overallLessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2<Node, Object, Object> & Serializable)(node, next) -> {
            node.overallMoreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
    }

    private static final class Node<A> {
        private final A value;
        private int level;
        private long timestamp;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private Node<A> overallLessRecent;
        private Node<A> overallMoreRecent;

        public A value() {
            return this.value;
        }

        public int level() {
            return this.level;
        }

        public void level_$eq(int x$1) {
            this.level = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public Node<A> overallLessRecent() {
            return this.overallLessRecent;
        }

        public void overallLessRecent_$eq(Node<A> x$1) {
            this.overallLessRecent = x$1;
        }

        public Node<A> overallMoreRecent() {
            return this.overallMoreRecent;
        }

        public void overallMoreRecent_$eq(Node<A> x$1) {
            this.overallMoreRecent = x$1;
        }

        public Node(A value) {
            this.value = value;
            this.level = 0;
            this.timestamp = 0L;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            OptionVal$.MODULE$.None();
            this.overallLessRecent = null;
            OptionVal$.MODULE$.None();
            this.overallMoreRecent = null;
        }
    }
}

