/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import java.lang.reflect.Array;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class HashCode$ {
    public static final HashCode$ MODULE$ = new HashCode$();
    private static final int SEED = 23;
    private static final int PRIME = 37;

    public int SEED() {
        return SEED;
    }

    public int hash(int seed, Object any) {
        int n;
        Object object = any;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean(object);
            n = this.hash(seed, bl);
        } else if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar(object);
            n = this.hash(seed, c);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort(object);
            n = this.hash(seed, s);
        } else if (object instanceof Integer) {
            int n2 = BoxesRunTime.unboxToInt(object);
            n = this.hash(seed, n2);
        } else if (object instanceof Long) {
            long l2 = BoxesRunTime.unboxToLong(object);
            n = this.hash(seed, l2);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(object);
            n = this.hash(seed, f);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(object);
            n = this.hash(seed, d);
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(object);
            n = this.hash(seed, by);
        } else if (object instanceof Object) {
            Object object2 = object;
            IntRef result2 = IntRef.create(seed);
            if (object2 == null) {
                result2.elem = this.hash(result2.elem, 0);
            } else if (!this.isArray(object2)) {
                result2.elem = this.hash(result2.elem, object2.hashCode());
            } else {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Array.getLength(object2)).foreach$mVc$sp(id -> {
                    result$1.elem = MODULE$.hash(result$1.elem, Array.get(object2, id));
                });
            }
            n = result2.elem;
        } else {
            throw new IllegalArgumentException(new StringBuilder(27).append("Unexpected hash parameter: ").append(object).toString());
        }
        return n;
    }

    public int hash(int seed, boolean value) {
        return this.firstTerm(seed) + (value ? 1 : 0);
    }

    public int hash(int seed, char value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, int value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, long value) {
        return this.firstTerm(seed) + (int)(value ^ value >>> 32);
    }

    public int hash(int seed, float value) {
        return this.hash(seed, Float.floatToIntBits(value));
    }

    public int hash(int seed, double value) {
        return this.hash(seed, Double.doubleToLongBits(value));
    }

    private int firstTerm(int seed) {
        return this.PRIME() * seed;
    }

    private boolean isArray(Object anyRef) {
        return anyRef.getClass().isArray();
    }

    private int PRIME() {
        return PRIME;
    }

    private HashCode$() {
    }
}

