/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern.internal;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.pattern.internal.CircuitBreakerEnsembleTelemetry;
import akka.pattern.internal.CircuitBreakerNoopTelemetry$;
import akka.pattern.internal.CircuitBreakerTelemetry;
import akka.util.ccompat.package$JavaConverters$;
import java.util.List;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class CircuitBreakerTelemetryProvider$ {
    public static final CircuitBreakerTelemetryProvider$ MODULE$ = new CircuitBreakerTelemetryProvider$();

    public CircuitBreakerTelemetry start(String breakerId, ExtendedActorSystem system) {
        CircuitBreakerTelemetry circuitBreakerTelemetry;
        String configPath = "akka.circuit-breaker.telemetry.implementations";
        if (!system.settings().config().hasPath(configPath)) {
            circuitBreakerTelemetry = CircuitBreakerNoopTelemetry$.MODULE$;
        } else {
            List<String> telemetryFqcns = system.settings().config().getStringList(configPath);
            int n = telemetryFqcns.size();
            switch (n) {
                case 0: {
                    circuitBreakerTelemetry = CircuitBreakerNoopTelemetry$.MODULE$;
                    break;
                }
                case 1: {
                    String fqcn = telemetryFqcns.get(0);
                    circuitBreakerTelemetry = this.create(breakerId, system, fqcn);
                    break;
                }
                default: {
                    circuitBreakerTelemetry = new CircuitBreakerEnsembleTelemetry(package$JavaConverters$.MODULE$.ListHasAsScala(telemetryFqcns).asScala().toSeq(), breakerId, system);
                    break;
                }
            }
        }
        return circuitBreakerTelemetry;
    }

    public CircuitBreakerTelemetry create(String breakerId, ExtendedActorSystem system, String fqcn) {
        return (CircuitBreakerTelemetry)system.dynamicAccess().createInstanceFor(fqcn, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), breakerId), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), system)})), ClassTag$.MODULE$.apply(CircuitBreakerTelemetry.class)).get();
    }

    private CircuitBreakerTelemetryProvider$() {
    }
}

