/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.impl.source.tree.java.PsiPolyadicExpressionImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiBinaryExpressionImpl
extends ExpressionPsiElement
implements PsiBinaryExpression {
    private static final Logger LOG = Logger.getInstance(PsiBinaryExpressionImpl.class);
    private static final Function<PsiBinaryExpressionImpl, PsiType> MY_TYPE_EVALUATOR = expression2 -> PsiBinaryExpressionImpl.doGetType(expression2);
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create(JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);

    public PsiBinaryExpressionImpl() {
        this(JavaElementType.BINARY_EXPRESSION);
    }

    protected PsiBinaryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    public PsiExpression getLOperand() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(61);
        if (psiExpression == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(1);
        }
        return psiExpression;
    }

    @Override
    public PsiExpression getROperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(62);
    }

    @Override
    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = (PsiJavaToken)this.findChildByRoleAsPsiElement(63);
        if (psiJavaToken == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.getOperationSign().getTokenType();
        if (iElementType == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(4);
        }
        if (operand != this.getROperand()) {
            return null;
        }
        return this.getOperationSign();
    }

    private static PsiType doGetType(PsiBinaryExpressionImpl param) {
        IElementType sign;
        PsiExpression lOperand = param.getLOperand();
        PsiExpression rOperand = param.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiType rType = rOperand.getType();
        PsiType type = TypeConversionUtil.calcTypeForBinaryExpression(null, rType, sign = param.getOperationTokenType(), false);
        if (type != TypeConversionUtil.NULL_TYPE) {
            return type;
        }
        PsiType lType = lOperand.getType();
        return TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, sign, true);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 61: {
                return this.getFirstChildNode();
            }
            case 62: {
                return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            if (child == this.getFirstChildNode()) {
                return 61;
            }
            if (child == this.getLastChildNode()) {
                return 62;
            }
            return 0;
        }
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(6);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBinaryExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(9);
        }
        return PsiPolyadicExpressionImpl.processDeclarations(this, processor, state, lastParent, place);
    }

    @Override
    public PsiExpression @NotNull [] getOperands() {
        PsiExpression[] psiExpressionArray;
        PsiExpression rOperand = this.getROperand();
        if (rOperand == null) {
            PsiExpression[] psiExpressionArray2 = new PsiExpression[1];
            psiExpressionArray = psiExpressionArray2;
            psiExpressionArray2[0] = this.getLOperand();
        } else {
            PsiExpression[] psiExpressionArray3 = new PsiExpression[2];
            psiExpressionArray3[0] = this.getLOperand();
            psiExpressionArray = psiExpressionArray3;
            psiExpressionArray3[1] = rOperand;
        }
        if (psiExpressionArray == null) {
            PsiBinaryExpressionImpl.$$$reportNull$$$0(10);
        }
        return psiExpressionArray;
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        this.checkPersistentElementRemoval(first, last);
        super.deleteChildRange(first, last);
    }

    private void checkPersistentElementRemoval(PsiElement first, PsiElement last) {
        boolean inside = false;
        for (ASTNode node = this.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            int role;
            if (node.getPsi() == first) {
                inside = true;
            }
            if (inside && ((role = this.getChildRole(node)) == 63 || role == 61)) {
                LOG.error("Unable to remove child with role " + role + "(" + node.getElementType() + ")");
            }
            if (node.getPsi() != last) continue;
            inside = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLOperand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationTokenType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperands";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTokenBeforeOperand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

