/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;

public interface TrustedProxyCheck {
    public static TrustedProxyCheck allowAll() {
        return new TrustedProxyCheck(){

            @Override
            public boolean isProxyAllowed() {
                return true;
            }
        };
    }

    public static TrustedProxyCheck denyAll() {
        return new TrustedProxyCheck(){

            @Override
            public boolean isProxyAllowed() {
                return false;
            }
        };
    }

    public boolean isProxyAllowed();

    public static BiPredicate<InetAddress, Integer> createNewIpCheck(final InetAddress trustedIP, final int trustedPort) {
        final boolean doNotCheckPort = trustedPort == 0;
        return new BiPredicate<InetAddress, Integer>(){

            @Override
            public boolean test(InetAddress proxyIP, Integer proxyPort) {
                return this.isPortOk(proxyPort) && trustedIP.equals(proxyIP);
            }

            private boolean isPortOk(int port) {
                return doNotCheckPort || port == trustedPort;
            }
        };
    }

    public static BiPredicate<InetAddress, Integer> createNewIpCheck(final Collection<InetAddress> trustedIP, final int trustedPort) {
        final boolean doNotCheckPort = trustedPort == 0;
        return new BiPredicate<InetAddress, Integer>(){

            @Override
            public boolean test(InetAddress proxyIP, Integer proxyPort) {
                return this.isPortOk(proxyPort) && trustedIP.contains(proxyIP);
            }

            private boolean isPortOk(int port) {
                return doNotCheckPort || port == trustedPort;
            }
        };
    }

    public static final class TrustedProxyCheckPart {
        final BiPredicate<InetAddress, Integer> proxyCheck;
        final String hostName;
        final int port;

        TrustedProxyCheckPart(BiPredicate<InetAddress, Integer> proxyCheck) {
            this.proxyCheck = proxyCheck;
            this.hostName = null;
            this.port = 0;
        }

        TrustedProxyCheckPart(String hostName, int port) {
            this.proxyCheck = null;
            this.hostName = hostName;
            this.port = port;
        }
    }

    public static final class TrustedProxyCheckBuilder {
        private final Map<String, Integer> hostNameToPort;
        private final List<BiPredicate<InetAddress, Integer>> proxyChecks;

        private TrustedProxyCheckBuilder(Map<String, Integer> hostNameToPort, List<BiPredicate<InetAddress, Integer>> proxyChecks) {
            this.hostNameToPort = TrustedProxyCheckBuilder.hasHostNames(hostNameToPort) ? Map.copyOf(hostNameToPort) : null;
            this.proxyChecks = List.copyOf(proxyChecks);
        }

        static TrustedProxyCheckBuilder builder(List<TrustedProxyCheckPart> parts) {
            HashMap<String, Integer> hostNameToPort = new HashMap<String, Integer>();
            ArrayList<BiPredicate<InetAddress, Integer>> proxyChecks = new ArrayList<BiPredicate<InetAddress, Integer>>();
            for (TrustedProxyCheckPart part : parts) {
                if (part.proxyCheck != null) {
                    proxyChecks.add(part.proxyCheck);
                    continue;
                }
                hostNameToPort.put(part.hostName, part.port);
            }
            return new TrustedProxyCheckBuilder(hostNameToPort, proxyChecks);
        }

        TrustedProxyCheckBuilder withTrustedIP(Collection<InetAddress> trustedIP, int trustedPort) {
            ArrayList<BiPredicate<InetAddress, Integer>> proxyChecks = new ArrayList<BiPredicate<InetAddress, Integer>>(this.proxyChecks);
            proxyChecks.add(TrustedProxyCheck.createNewIpCheck(trustedIP, trustedPort));
            return new TrustedProxyCheckBuilder(null, proxyChecks);
        }

        boolean hasProxyChecks() {
            return !this.proxyChecks.isEmpty();
        }

        TrustedProxyCheck build(final InetAddress proxyIP, final int proxyPort) {
            Objects.requireNonNull(proxyIP);
            return new TrustedProxyCheck(){

                @Override
                public boolean isProxyAllowed() {
                    for (BiPredicate<InetAddress, Integer> proxyCheck : proxyChecks) {
                        if (!proxyCheck.test(proxyIP, proxyPort)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        TrustedProxyCheck build(Collection<InetAddress> proxyIPs, int proxyPort) {
            Objects.requireNonNull(proxyIPs);
            return () -> {
                for (BiPredicate<InetAddress, Integer> proxyCheck : this.proxyChecks) {
                    for (InetAddress proxyIP : proxyIPs) {
                        if (!proxyCheck.test(proxyIP, proxyPort)) continue;
                        return true;
                    }
                }
                return false;
            };
        }

        boolean hasHostNames() {
            return TrustedProxyCheckBuilder.hasHostNames(this.hostNameToPort);
        }

        private static boolean hasHostNames(Map<String, Integer> hostNameToPort) {
            return hostNameToPort != null && !hostNameToPort.isEmpty();
        }

        public Map<String, Integer> getHostNameToPort() {
            return this.hostNameToPort;
        }
    }
}

