/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;

public class WaypointComparer {
    public static CompareResult compare(DataPoint dataPoint, DataPoint dataPoint2) {
        if (!(dataPoint.isWaypoint() && dataPoint2.isWaypoint() && dataPoint.getWaypointName().equals(dataPoint2.getWaypointName()))) {
            return CompareResult.DIFFERENT;
        }
        boolean bl = false;
        boolean bl2 = false;
        FieldList fieldList = dataPoint.getFieldList().merge(dataPoint2.getFieldList());
        int n = 0;
        while (n < fieldList.getNumFields()) {
            Field field = fieldList.getField(n);
            String string = dataPoint.getFieldValue(field);
            String string2 = dataPoint2.getFieldValue(field);
            boolean bl3 = WaypointComparer.hasValue(string);
            boolean bl4 = WaypointComparer.hasValue(string2);
            if (bl3 && !bl4) {
                bl = true;
            } else if (!bl3 && bl4) {
                bl2 = true;
            } else if (bl3 && bl4 && !string.equals(string2)) {
                return CompareResult.DIFFERENT;
            }
            ++n;
        }
        if (!bl && !bl2) {
            return CompareResult.IDENTICAL;
        }
        if (bl && !bl2) {
            return CompareResult.FIRST_BETTER;
        }
        if (!bl && bl2) {
            return CompareResult.SECOND_BETTER;
        }
        return CompareResult.COMPLEMENTARY;
    }

    private static boolean hasValue(String string) {
        return string != null && !string.isEmpty();
    }

    public static enum CompareResult {
        IDENTICAL,
        FIRST_BETTER,
        SECOND_BETTER,
        COMPLEMENTARY,
        DIFFERENT;

    }
}

