/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.edit.PointEdit;

public class EditSingleFieldCmd
extends Command {
    private final Field _field;
    private final List<PointEdit> _editList;

    public EditSingleFieldCmd(Field field, List<PointEdit> list) {
        this(null, field, list);
    }

    protected EditSingleFieldCmd(EditSingleFieldCmd editSingleFieldCmd, Field field, List<PointEdit> list) {
        super(editSingleFieldCmd);
        this._field = field;
        this._editList = list;
    }

    @Override
    public int getUpdateFlags() {
        return 2;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        if (this._field == null) {
            return false;
        }
        trackInfo.getTrack().getFieldList().extendList(this._field);
        for (PointEdit pointEdit : this._editList) {
            trackInfo.getTrack().getPoint(pointEdit.getPointIndex()).setFieldValue(this._field, pointEdit.getValue(), this.isUndo());
        }
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        return new EditSingleFieldCmd(this, this._field, this.makeOppositeEdits(trackInfo.getTrack()));
    }

    private List<PointEdit> makeOppositeEdits(Track track) {
        ArrayList<PointEdit> arrayList = new ArrayList<PointEdit>();
        for (PointEdit pointEdit : this._editList) {
            String string = track.getPoint(pointEdit.getPointIndex()).getFieldValue(this._field);
            arrayList.add(new PointEdit(pointEdit.getPointIndex(), string));
        }
        return arrayList;
    }
}

