/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GetStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private StreamContext streamContext;
    private String name;
    private Iterator<Tuple> tupleIterator;

    public GetStream(String name) throws IOException {
        this.init(name);
    }

    public GetStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String name = factory.getValueOperand(expression, 0);
        this.init(name);
    }

    private void init(String name) {
        this.name = name;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.name);
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.tupleIterator.hasNext()) {
            Tuple t = this.tupleIterator.next();
            return t.clone();
        }
        return Tuple.EOF();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
        Map<String, Object> lets = this.streamContext.getLets();
        Object o = lets.get(this.name);
        if (o instanceof List) {
            List l = (List)o;
            this.tupleIterator = l.iterator();
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

