/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.CorePath;
import com.intellij.platform.core.nio.fs.CoreRoutingFileSystemDelegate;
import com.intellij.platform.core.nio.fs.CoreRoutingFileSystemProvider;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreRoutingFileSystem
extends FileSystem {
    private final CoreRoutingFileSystemProvider myProvider;
    private final FileSystem myLocalFS;
    private volatile FileSystem myMountedFS;
    private volatile CoreRoutingFileSystemDelegate myDelegate;
    private static volatile String ourMountedFSPrefix;

    public CoreRoutingFileSystem(CoreRoutingFileSystemProvider provider, FileSystem localFS) {
        this.myProvider = provider;
        this.myLocalFS = localFS;
    }

    public void initialize(@NotNull String filesystemClassName, @Nullable Class<? extends CoreRoutingFileSystemDelegate> routingFilesystemDelegateClass) {
        if (filesystemClassName == null) {
            CoreRoutingFileSystem.$$$reportNull$$$0(0);
        }
        this.myMountedFS = (FileSystem)this.myProvider.createInstance(filesystemClassName, new Class[]{FileSystemProvider.class}, this.myProvider);
        if (routingFilesystemDelegateClass != null) {
            try {
                this.myDelegate = routingFilesystemDelegateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setMountedFSPrefix(@NotNull String mountedFSPrefix) {
        if (mountedFSPrefix == null) {
            CoreRoutingFileSystem.$$$reportNull$$$0(1);
        }
        ourMountedFSPrefix = mountedFSPrefix;
    }

    public boolean isInitialized() {
        return this.myMountedFS != null;
    }

    @Override
    public FileSystemProvider provider() {
        return this.myProvider;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return this.myLocalFS.isOpen() || this.myMountedFS != null && this.myMountedFS.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.myLocalFS.isReadOnly() && (this.myMountedFS == null || this.myMountedFS.isReadOnly());
    }

    @Override
    public String getSeparator() {
        return this.myLocalFS.getSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        final Iterable<Path> roots = CoreRoutingFileSystem.concat(this.myLocalFS.getRootDirectories(), this.myMountedFS == null ? Collections.emptyList() : this.myMountedFS.getRootDirectories());
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                final Iterator iterator = roots.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        return CoreRoutingFileSystemProvider.path(CoreRoutingFileSystem.this, (Path)iterator.next());
                    }
                };
            }
        };
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return CoreRoutingFileSystem.concat(this.myLocalFS.getFileStores(), this.myMountedFS == null ? Collections.emptyList() : this.myMountedFS.getFileStores());
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        HashSet<String> result = new HashSet<String>(this.myLocalFS.supportedFileAttributeViews());
        if (this.myMountedFS != null) {
            result.addAll(this.myMountedFS.supportedFileAttributeViews());
        }
        return result;
    }

    @Override
    public Path getPath(String first, String ... more) {
        FileSystem fs = this.myMountedFS != null && CoreRoutingFileSystem.isMountedFSFile(first) ? this.myMountedFS : this.myLocalFS;
        Path result = CoreRoutingFileSystemProvider.path(this, fs.getPath(first, more));
        CoreRoutingFileSystemDelegate delegate = this.myDelegate;
        return delegate == null ? result : delegate.wrap(result);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return this.myLocalFS.getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.myLocalFS.getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.myLocalFS.newWatchService();
    }

    public boolean isMountedFSPath(CorePath path) {
        if (path.isMountedFS()) {
            return true;
        }
        CoreRoutingFileSystemDelegate delegate = this.myDelegate;
        return delegate != null && delegate.isMountedFSPath(path);
    }

    public static boolean isMountedFSFile(String virtualFilePath) {
        return CoreRoutingFileSystemProvider.normalizePath(virtualFilePath).startsWith(ourMountedFSPrefix);
    }

    private static <T> Iterable<T> concat(Iterable<T> first, Iterable<T> second) {
        Stream<T> firstStream = StreamSupport.stream(first.spliterator(), false);
        Stream<T> secondStream = StreamSupport.stream(second.spliterator(), false);
        final Stream<T> concat = Stream.concat(firstStream, secondStream);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return concat.iterator();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesystemClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mountedFSPrefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/core/nio/fs/CoreRoutingFileSystem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setMountedFSPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

