/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.store.IndexIntervalManager;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.NodeStoreLarge;
import com.amazon.randomcutforest.tree.NodeStoreMedium;
import com.amazon.randomcutforest.tree.NodeStoreSmall;
import com.amazon.randomcutforest.tree.NodeView;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import java.util.function.Function;

public abstract class AbstractNodeStore {
    public static double SWITCH_FRACTION = 0.499;
    public static int Null = -1;
    public static boolean DEFAULT_STORE_PARENT = false;
    protected final int capacity;
    protected final int dimensions;
    protected final float[] cutValue;
    protected double boundingboxCacheFraction;
    protected IndexIntervalManager freeNodeManager;
    protected double[] rangeSumData;
    protected float[] boundingBoxData;
    protected final IPointStoreView<float[]> pointStoreView;
    protected final HashMap<Integer, Integer> leafMass;
    protected boolean centerOfMassEnabled;
    protected boolean storeSequenceIndexesEnabled;
    protected float[] pointSum;
    protected HashMap<Integer, HashMap<Long, Integer>> sequenceMap;

    public AbstractNodeStore(Builder<?> builder) {
        this.capacity = builder.capacity;
        this.dimensions = builder.dimensions;
        if (builder.leftIndex == null) {
            this.freeNodeManager = new IndexIntervalManager(this.capacity);
        }
        this.boundingboxCacheFraction = builder.boundingBoxCacheFraction;
        this.cutValue = builder.cutValues != null ? builder.cutValues : new float[this.capacity];
        this.leafMass = new HashMap();
        int cache_limit = (int)Math.floor(this.boundingboxCacheFraction * (double)this.capacity);
        this.rangeSumData = new double[cache_limit];
        this.boundingBoxData = new float[2 * this.dimensions * cache_limit];
        this.pointStoreView = builder.pointStoreView;
        this.centerOfMassEnabled = builder.centerOfMassEnabled;
        this.storeSequenceIndexesEnabled = builder.storeSequencesEnabled;
        if (this.centerOfMassEnabled) {
            this.pointSum = new float[this.capacity * this.dimensions];
        }
        if (this.storeSequenceIndexesEnabled) {
            this.sequenceMap = new HashMap();
        }
    }

    protected abstract int addNode(Stack<int[]> var1, float[] var2, long var3, int var5, int var6, int var7, float var8, BoundingBox var9);

    protected int addLeaf(int pointIndex, long sequenceIndex) {
        if (this.storeSequenceIndexesEnabled) {
            Integer count;
            HashMap<Long, Integer> leafMap = this.sequenceMap.remove(pointIndex);
            if (leafMap == null) {
                leafMap = new HashMap();
            }
            if ((count = leafMap.remove(sequenceIndex)) != null) {
                leafMap.put(sequenceIndex, count + 1);
            } else {
                leafMap.put(sequenceIndex, 1);
            }
            this.sequenceMap.put(pointIndex, leafMap);
        }
        return pointIndex + this.capacity + 1;
    }

    public void removeLeaf(int leafPointIndex, long sequenceIndex) {
        HashMap<Long, Integer> leafMap = this.sequenceMap.remove(leafPointIndex);
        CommonUtils.checkArgument(leafMap != null, " leaf index not found in tree");
        Integer count = leafMap.remove(sequenceIndex);
        CommonUtils.checkArgument(count != null, " sequence index not found in leaf");
        if (count > 1) {
            leafMap.put(sequenceIndex, count - 1);
            this.sequenceMap.put(leafPointIndex, leafMap);
        } else if (leafMap.size() > 0) {
            this.sequenceMap.put(leafPointIndex, leafMap);
        }
    }

    public boolean isLeaf(int index) {
        return index > this.capacity;
    }

    public boolean isInternal(int index) {
        return index < this.capacity && index >= 0;
    }

    public abstract void addToPartialTree(Stack<int[]> var1, float[] var2, int var3);

    public abstract int getLeftIndex(int var1);

    public abstract int getRightIndex(int var1);

    public abstract void setRoot(int var1);

    public float[] getPointSum(int index) {
        CommonUtils.checkArgument(this.centerOfMassEnabled, " enable center of mass");
        return this.isLeaf(index) ? this.pointStoreView.getScaledPoint(this.getPointIndex(index), this.getMass(index)) : Arrays.copyOfRange(this.pointSum, index * this.dimensions, (index + 1) * this.dimensions);
    }

    public void invalidatePointSum(int index) {
        for (int i = 0; i < this.dimensions; ++i) {
            this.pointSum[index * this.dimensions + i] = 0.0f;
        }
    }

    public void recomputePointSum(int index) {
        float[] left = this.getPointSum(this.getLeftIndex(index));
        float[] right = this.getPointSum(this.getRightIndex(index));
        for (int i = 0; i < this.dimensions; ++i) {
            this.pointSum[index * this.dimensions + i] = left[i] + right[i];
        }
    }

    public void increaseLeafMass(int index) {
        int y = index - this.capacity - 1;
        this.leafMass.merge(y, 1, Integer::sum);
    }

    public int decreaseLeafMass(int index) {
        int y = index - this.capacity - 1;
        Integer value = this.leafMass.remove(y);
        if (value != null) {
            if (value > 1) {
                this.leafMass.put(y, value - 1);
                return value;
            }
            return 1;
        }
        return 0;
    }

    public void resizeCache(double fraction) {
        if (fraction == 0.0) {
            this.rangeSumData = null;
            this.boundingBoxData = null;
        } else {
            int limit = (int)Math.floor(fraction * (double)this.capacity);
            this.rangeSumData = this.rangeSumData == null ? new double[limit] : Arrays.copyOf(this.rangeSumData, limit);
            this.boundingBoxData = this.boundingBoxData == null ? new float[limit * 2 * this.dimensions] : Arrays.copyOf(this.boundingBoxData, limit * 2 * this.dimensions);
        }
        this.boundingboxCacheFraction = fraction;
    }

    public int translate(int index) {
        if (this.rangeSumData.length <= index) {
            return Integer.MAX_VALUE;
        }
        return index;
    }

    void copyBoxToData(int idx, BoundingBox box) {
        int base = 2 * idx * this.dimensions;
        int mid = base + this.dimensions;
        System.arraycopy(box.getMinValues(), 0, this.boundingBoxData, base, this.dimensions);
        System.arraycopy(box.getMaxValues(), 0, this.boundingBoxData, mid, this.dimensions);
        this.rangeSumData[idx] = box.getRangeSum();
    }

    public boolean checkContainsAndAddPoint(int index, float[] point) {
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE && this.rangeSumData[idx] != 0.0) {
            int i;
            int base = 2 * idx * this.dimensions;
            int mid = base + this.dimensions;
            double rangeSum = 0.0;
            for (i = 0; i < this.dimensions; ++i) {
                this.boundingBoxData[base + i] = Math.min(this.boundingBoxData[base + i], point[i]);
            }
            for (i = 0; i < this.dimensions; ++i) {
                this.boundingBoxData[mid + i] = Math.max(this.boundingBoxData[mid + i], point[i]);
            }
            for (i = 0; i < this.dimensions; ++i) {
                rangeSum += (double)(this.boundingBoxData[mid + i] - this.boundingBoxData[base + i]);
            }
            boolean answer = this.rangeSumData[idx] == rangeSum;
            this.rangeSumData[idx] = rangeSum;
            return answer;
        }
        return false;
    }

    public BoundingBox getBox(int index) {
        if (this.isLeaf(index)) {
            float[] point = this.pointStoreView.get(this.getPointIndex(index));
            return new BoundingBox(point, point);
        }
        CommonUtils.checkArgument(this.isInternal(index), " incomplete state");
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            if (this.rangeSumData[idx] != 0.0) {
                return this.getBoxFromData(idx);
            }
            BoundingBox box = this.reconstructBox(index, this.pointStoreView);
            this.copyBoxToData(idx, box);
            return box;
        }
        return this.reconstructBox(index, this.pointStoreView);
    }

    public BoundingBox reconstructBox(int index, IPointStoreView<float[]> pointStoreView) {
        BoundingBox mutatedBoundingBox = this.getBox(this.getLeftIndex(index));
        this.growNodeBox(mutatedBoundingBox, pointStoreView, index, this.getRightIndex(index));
        return mutatedBoundingBox;
    }

    boolean checkStrictlyContains(int index, float[] point) {
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            int base = 2 * idx * this.dimensions;
            int mid = base + this.dimensions;
            boolean isInside = true;
            for (int i = 0; i < this.dimensions && isInside; ++i) {
                if (!(point[i] >= this.boundingBoxData[mid + i]) && !(this.boundingBoxData[base + i] >= point[i])) continue;
                isInside = false;
            }
            return isInside;
        }
        return false;
    }

    public boolean checkContainsAndRebuildBox(int index, float[] point, IPointStoreView<float[]> pointStoreView) {
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE && this.rangeSumData[idx] != 0.0) {
            if (!this.checkStrictlyContains(index, point)) {
                BoundingBox mutatedBoundingBox = this.reconstructBox(index, pointStoreView);
                this.copyBoxToData(idx, mutatedBoundingBox);
                return false;
            }
            return true;
        }
        return false;
    }

    public BoundingBox getBoxFromData(int idx) {
        int base = 2 * idx * this.dimensions;
        int mid = base + this.dimensions;
        return new BoundingBox(Arrays.copyOfRange(this.boundingBoxData, base, base + this.dimensions), Arrays.copyOfRange(this.boundingBoxData, mid, mid + this.dimensions));
    }

    protected void addBox(int index, float[] point, BoundingBox box) {
        int idx;
        if (this.isInternal(index) && (idx = this.translate(index)) != Integer.MAX_VALUE) {
            this.copyBoxToData(idx, box);
            this.checkContainsAndAddPoint(index, point);
        }
    }

    public void growNodeBox(BoundingBox box, IPointStoreView<float[]> pointStoreView, int node, int sibling) {
        if (!this.isLeaf(sibling)) {
            CommonUtils.checkArgument(this.isInternal(sibling), " incomplete state " + sibling);
            int siblingIdx = this.translate(sibling);
            if (siblingIdx != Integer.MAX_VALUE) {
                if (this.rangeSumData[siblingIdx] != 0.0) {
                    box.addBox(this.getBoxFromData(siblingIdx));
                } else {
                    BoundingBox newBox = this.getBox(siblingIdx);
                    this.copyBoxToData(siblingIdx, newBox);
                    box.addBox(newBox);
                }
                return;
            }
            this.growNodeBox(box, pointStoreView, sibling, this.getLeftIndex(sibling));
            this.growNodeBox(box, pointStoreView, sibling, this.getRightIndex(sibling));
            return;
        }
        float[] point = pointStoreView.get(this.getPointIndex(sibling));
        box.addPoint(point);
    }

    public double probabilityOfCut(int node, float[] point, IPointStoreView<float[]> pointStoreView, BoundingBox otherBox) {
        int nodeIdx = this.translate(node);
        if (nodeIdx != Integer.MAX_VALUE && this.rangeSumData[nodeIdx] != 0.0) {
            int i;
            int base = 2 * nodeIdx * this.dimensions;
            int mid = base + this.dimensions;
            double minsum = 0.0;
            double maxsum = 0.0;
            for (i = 0; i < this.dimensions; ++i) {
                minsum += (double)Math.max(this.boundingBoxData[base + i] - point[i], 0.0f);
            }
            for (i = 0; i < this.dimensions; ++i) {
                maxsum += (double)Math.max(point[i] - this.boundingBoxData[mid + i], 0.0f);
            }
            double sum = maxsum + minsum;
            if (sum == 0.0) {
                return 0.0;
            }
            return sum / (this.rangeSumData[nodeIdx] + sum);
        }
        if (otherBox != null) {
            return otherBox.probabilityOfCut(point);
        }
        BoundingBox box = this.getBox(node);
        return box.probabilityOfCut(point);
    }

    protected abstract void decreaseMassOfInternalNode(int var1);

    protected abstract void increaseMassOfInternalNode(int var1);

    protected void manageAncestorsAdd(Stack<int[]> path, float[] point, IPointStoreView<float[]> pointStoreview) {
        while (!path.isEmpty()) {
            int index = path.pop()[0];
            this.increaseMassOfInternalNode(index);
            if (this.pointSum != null) {
                this.recomputePointSum(index);
            }
            if (!(this.boundingboxCacheFraction > 0.0)) continue;
            this.checkContainsAndRebuildBox(index, point, pointStoreview);
            this.checkContainsAndAddPoint(index, point);
        }
    }

    protected void manageAncestorsDelete(Stack<int[]> path, float[] point, IPointStoreView<float[]> pointStoreview) {
        boolean resolved = false;
        while (!path.isEmpty()) {
            int index = path.pop()[0];
            this.decreaseMassOfInternalNode(index);
            if (this.pointSum != null) {
                this.recomputePointSum(index);
            }
            if (!(this.boundingboxCacheFraction > 0.0) || resolved) continue;
            resolved = this.checkContainsAndRebuildBox(index, point, pointStoreview);
        }
    }

    public Stack<int[]> getPath(int root, float[] point, boolean verbose) {
        int node = root;
        Stack<int[]> answer = new Stack<int[]>();
        answer.push(new int[]{root, this.capacity});
        while (this.isInternal(node)) {
            double y = this.getCutValue(node);
            if (this.leftOf(node, point)) {
                answer.push(new int[]{this.getLeftIndex(node), this.getRightIndex(node)});
                node = this.getLeftIndex(node);
                continue;
            }
            answer.push(new int[]{this.getRightIndex(node), this.getLeftIndex(node)});
            node = this.getRightIndex(node);
        }
        return answer;
    }

    public abstract void deleteInternalNode(int var1);

    public int getLeafMass(int index) {
        int y = index - this.capacity - 1;
        Integer value = this.leafMass.get(y);
        if (value != null) {
            return value + 1;
        }
        return 1;
    }

    public abstract int getMass(int var1);

    public int getPointIndex(int index) {
        return index - this.capacity - 1;
    }

    protected boolean leftOf(float cutValue, int cutDimension, float[] point) {
        return point[cutDimension] <= cutValue;
    }

    public boolean leftOf(int node, float[] point) {
        int cutDimension = this.getCutDimension(node);
        return this.leftOf(this.cutValue[node], cutDimension, point);
    }

    public int getSibling(int node, int parent) {
        int sibling = this.getLeftIndex(parent);
        if (node == sibling) {
            sibling = this.getRightIndex(parent);
        }
        return sibling;
    }

    public abstract void spliceEdge(int var1, int var2, int var3);

    public abstract void replaceParentBySibling(int var1, int var2, int var3);

    public HashMap<Integer, HashMap<Long, Integer>> getSequenceMap() {
        return this.sequenceMap;
    }

    public abstract int getCutDimension(int var1);

    public double getCutValue(int index) {
        return this.cutValue[index];
    }

    public double getBoundingboxCacheFraction() {
        return this.boundingboxCacheFraction;
    }

    protected <R> void traversePathToLeafAndVisitNodes(float[] point, Visitor<R> visitor, int root, IPointStoreView<float[]> pointStoreView, Function<float[], float[]> projectToTree) {
        NodeView currentNodeView = new NodeView(this, pointStoreView, root);
        this.traversePathToLeafAndVisitNodes(point, visitor, currentNodeView, root, 0);
    }

    protected boolean toLeft(float[] point, int currentNodeOffset) {
        return point[this.getCutDimension(currentNodeOffset)] <= this.cutValue[currentNodeOffset];
    }

    BoundingBox getLeftBox(int index) {
        return this.getBox(this.getLeftIndex(index));
    }

    BoundingBox getRightBox(int index) {
        return this.getBox(this.getRightIndex(index));
    }

    protected <R> void traversePathToLeafAndVisitNodes(float[] point, Visitor<R> visitor, NodeView currentNodeView, int node, int depthOfNode) {
        if (this.isLeaf(node)) {
            currentNodeView.setCurrentNode(node, this.getPointIndex(node), true);
            visitor.acceptLeaf(currentNodeView, depthOfNode);
        } else {
            CommonUtils.checkArgument(this.isInternal(node), " incomplete state " + node + " " + depthOfNode);
            if (this.toLeft(point, node)) {
                this.traversePathToLeafAndVisitNodes(point, visitor, currentNodeView, this.getLeftIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.getRightIndex(node), !visitor.isConverged());
            } else {
                this.traversePathToLeafAndVisitNodes(point, visitor, currentNodeView, this.getRightIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.getLeftIndex(node), !visitor.isConverged());
            }
            visitor.accept(currentNodeView, depthOfNode);
        }
    }

    protected <R> void traverseTreeMulti(float[] point, MultiVisitor<R> visitor, int root, IPointStoreView<float[]> pointStoreView, Function<float[], float[]> liftToTree) {
        NodeView currentNodeView = new NodeView(this, pointStoreView, root);
        this.traverseTreeMulti(point, visitor, currentNodeView, root, 0);
    }

    protected <R> void traverseTreeMulti(float[] point, MultiVisitor<R> visitor, NodeView currentNodeView, int node, int depthOfNode) {
        if (this.isLeaf(node)) {
            currentNodeView.setCurrentNode(node, this.getPointIndex(node), false);
            visitor.acceptLeaf(currentNodeView, depthOfNode);
        } else {
            CommonUtils.checkArgument(this.isInternal(node), " incomplete state");
            currentNodeView.setCurrentNodeOnly(node);
            if (visitor.trigger(currentNodeView)) {
                this.traverseTreeMulti(point, visitor, currentNodeView, this.getLeftIndex(node), depthOfNode + 1);
                MultiVisitor<R> newVisitor = visitor.newCopy();
                currentNodeView.setCurrentNodeOnly(this.getRightIndex(node));
                this.traverseTreeMulti(point, newVisitor, currentNodeView, this.getRightIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.getLeftIndex(node), false);
                visitor.combine(newVisitor);
            } else if (this.toLeft(point, node)) {
                this.traverseTreeMulti(point, visitor, currentNodeView, this.getLeftIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.getRightIndex(node), false);
            } else {
                this.traverseTreeMulti(point, visitor, currentNodeView, this.getRightIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.getLeftIndex(node), false);
            }
            visitor.accept(currentNodeView, depthOfNode);
        }
    }

    public abstract int[] getCutDimension();

    public abstract int[] getRightIndex();

    public abstract int[] getLeftIndex();

    public float[] getCutValues() {
        return this.cutValue;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int size() {
        return this.capacity - this.freeNodeManager.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int capacity;
        protected int[] leftIndex;
        protected int[] rightIndex;
        protected int[] cutDimension;
        protected float[] cutValues;
        protected int root;
        protected double boundingBoxCacheFraction;
        protected boolean centerOfMassEnabled;
        protected boolean storeSequencesEnabled;
        protected boolean storeParent = DEFAULT_STORE_PARENT;
        protected IPointStoreView<float[]> pointStoreView;

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T useRoot(int root) {
            this.root = root;
            return (T)this;
        }

        public T leftIndex(int[] leftIndex) {
            this.leftIndex = leftIndex;
            return (T)this;
        }

        public T rightIndex(int[] rightIndex) {
            this.rightIndex = rightIndex;
            return (T)this;
        }

        public T cutDimension(int[] cutDimension) {
            this.cutDimension = cutDimension;
            return (T)this;
        }

        public T cutValues(float[] cutValues) {
            this.cutValues = cutValues;
            return (T)this;
        }

        public T pointStoreView(IPointStoreView<float[]> pointStoreView) {
            this.pointStoreView = pointStoreView;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T storeParent(boolean storeParent) {
            this.storeParent = storeParent;
            return (T)this;
        }

        public T storeSequencesEnabled(boolean storeSequencesEnabled) {
            this.storeSequencesEnabled = storeSequencesEnabled;
            return (T)this;
        }

        public AbstractNodeStore build() {
            CommonUtils.checkArgument(this.pointStoreView != null, " a point store view is required ");
            if (this.leftIndex == null) {
                CommonUtils.checkArgument(this.rightIndex == null, " incorrect option of right indices");
                CommonUtils.checkArgument(this.cutValues == null, "incorrect option of cut values");
                CommonUtils.checkArgument(this.cutDimension == null, " incorrect option of cut dimensions");
            } else {
                CommonUtils.checkArgument(this.rightIndex.length == this.capacity, " incorrect length of right indices");
                CommonUtils.checkArgument(this.cutValues.length == this.capacity, "incorrect length of cut values");
                CommonUtils.checkArgument(this.cutDimension.length == this.capacity, " incorrect length of cut dimensions");
            }
            if (this.capacity < 256 && this.pointStoreView.getDimensions() <= 256) {
                return new NodeStoreSmall(this);
            }
            if (this.capacity < 65535 && this.pointStoreView.getDimensions() <= 65535) {
                return new NodeStoreMedium(this);
            }
            return new NodeStoreLarge(this);
        }
    }
}

