/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.FetchProfileBreakdown;
import org.opensearch.client.opensearch.core.search.FetchProfileDebug;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FetchProfile
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, FetchProfile> {
    @Nonnull
    private final FetchProfileBreakdown breakdown;
    @Nonnull
    private final List<FetchProfile> children;
    @Nullable
    private final FetchProfileDebug debug;
    @Nonnull
    private final String description;
    private final long timeInNanos;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<FetchProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FetchProfile::setupFetchProfileDeserializer);

    private FetchProfile(Builder builder) {
        this.breakdown = ApiTypeHelper.requireNonNull(builder.breakdown, this, "breakdown");
        this.children = ApiTypeHelper.unmodifiable(builder.children);
        this.debug = builder.debug;
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, this, "timeInNanos");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static FetchProfile of(Function<Builder, ObjectBuilder<FetchProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final FetchProfileBreakdown breakdown() {
        return this.breakdown;
    }

    @Nonnull
    public final List<FetchProfile> children() {
        return this.children;
    }

    @Nullable
    public final FetchProfileDebug debug() {
        return this.debug;
    }

    @Nonnull
    public final String description() {
        return this.description;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (FetchProfile item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.debug != null) {
            generator.writeKey("debug");
            this.debug.serialize(generator, mapper);
        }
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFetchProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::breakdown, FetchProfileBreakdown._DESERIALIZER, "breakdown");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
        op.add(Builder::debug, FetchProfileDebug._DESERIALIZER, "debug");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.breakdown.hashCode();
        result = 31 * result + Objects.hashCode(this.children);
        result = 31 * result + Objects.hashCode(this.debug);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + Long.hashCode(this.timeInNanos);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchProfile other = (FetchProfile)o;
        return this.breakdown.equals(other.breakdown) && Objects.equals(this.children, other.children) && Objects.equals(this.debug, other.debug) && this.description.equals(other.description) && this.timeInNanos == other.timeInNanos && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FetchProfile> {
        private FetchProfileBreakdown breakdown;
        @Nullable
        private List<FetchProfile> children;
        @Nullable
        private FetchProfileDebug debug;
        private String description;
        private Long timeInNanos;
        private String type;

        public Builder() {
        }

        private Builder(FetchProfile o) {
            this.breakdown = o.breakdown;
            this.children = Builder._listCopy(o.children);
            this.debug = o.debug;
            this.description = o.description;
            this.timeInNanos = o.timeInNanos;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.breakdown = o.breakdown;
            this.children = Builder._listCopy(o.children);
            this.debug = o.debug;
            this.description = o.description;
            this.timeInNanos = o.timeInNanos;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder breakdown(FetchProfileBreakdown value) {
            this.breakdown = value;
            return this;
        }

        @Nonnull
        public final Builder breakdown(Function<FetchProfileBreakdown.Builder, ObjectBuilder<FetchProfileBreakdown>> fn) {
            return this.breakdown(fn.apply(new FetchProfileBreakdown.Builder()).build());
        }

        @Nonnull
        public final Builder children(List<FetchProfile> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        @Nonnull
        public final Builder children(FetchProfile value, FetchProfile ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        @Nonnull
        public final Builder children(Function<Builder, ObjectBuilder<FetchProfile>> fn) {
            return this.children(fn.apply(new Builder()).build(), new FetchProfile[0]);
        }

        @Nonnull
        public final Builder debug(@Nullable FetchProfileDebug value) {
            this.debug = value;
            return this;
        }

        @Nonnull
        public final Builder debug(Function<FetchProfileDebug.Builder, ObjectBuilder<FetchProfileDebug>> fn) {
            return this.debug(fn.apply(new FetchProfileDebug.Builder()).build());
        }

        @Nonnull
        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public FetchProfile build() {
            this._checkSingleUse();
            return new FetchProfile(this);
        }
    }
}

