/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.autofollow;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.replication.ReplicationException;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.action.index.ReplicateIndexAction;
import org.opensearch.replication.action.index.ReplicateIndexRequest;
import org.opensearch.replication.action.index.ReplicateIndexResponse;
import org.opensearch.replication.action.status.ReplicationStatusAction;
import org.opensearch.replication.action.status.ReplicationStatusResponse;
import org.opensearch.replication.action.status.ShardInfoRequest;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.task.CrossClusterReplicationTask;
import org.opensearch.replication.task.autofollow.AutoFollowParams;
import org.opensearch.replication.task.autofollow.AutoFollowStat;
import org.opensearch.replication.task.autofollow.AutoFollowTask;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ \u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:H\u0094@\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u000206H\u0002J\u000e\u0010=\u001a\u000206H\u0094@\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u000206H\u0082@\u00a2\u0006\u0002\u0010>J\u001c\u0010@\u001a\u0002062\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050BH\u0082@\u00a2\u0006\u0002\u0010CJ\u0016\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u00020\u0005H\u0016J\b\u0010H\u001a\u00020IH\u0014J\b\u0010J\u001a\u000200H\u0016J\u000e\u0010K\u001a\u000206H\u0094@\u00a2\u0006\u0002\u0010>R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u001c\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000200X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006L"}, d2={"Lorg/opensearch/replication/task/autofollow/AutoFollowTask;", "Lorg/opensearch/replication/task/CrossClusterReplicationTask;", "id", "", "type", "", "action", "description", "parentTask", "Lorg/opensearch/core/tasks/TaskId;", "headers", "", "executor", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "client", "Lorg/opensearch/transport/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "params", "Lorg/opensearch/replication/task/autofollow/AutoFollowParams;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "<init>", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/core/tasks/TaskId;Ljava/util/Map;Ljava/lang/String;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/transport/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;Lorg/opensearch/replication/task/autofollow/AutoFollowParams;Lorg/opensearch/replication/ReplicationSettings;)V", "getParams", "()Lorg/opensearch/replication/task/autofollow/AutoFollowParams;", "leaderAlias", "getLeaderAlias", "()Ljava/lang/String;", "patternName", "getPatternName", "followerIndexName", "getFollowerIndexName", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/logging/log4j/Logger;", "trackingIndicesOnTheCluster", "", "replicationJobsQueue", "Ljava/util/concurrent/ConcurrentSkipListSet;", "retryScheduler", "Lorg/opensearch/threadpool/Scheduler$ScheduledCancellable;", "stat", "Lorg/opensearch/replication/task/autofollow/AutoFollowStat;", "getStat", "()Lorg/opensearch/replication/task/autofollow/AutoFollowStat;", "setStat", "(Lorg/opensearch/replication/task/autofollow/AutoFollowStat;)V", "execute", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "initialState", "Lorg/opensearch/persistent/PersistentTaskState;", "(Lkotlinx/coroutines/CoroutineScope;Lorg/opensearch/persistent/PersistentTaskState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addRetryScheduler", "cleanup", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollForIndices", "startReplicationJobs", "remoteIndices", "", "(Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startReplication", "leaderIndex", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "replicationTaskResponse", "Lorg/opensearch/replication/task/CrossClusterReplicationTask$CrossClusterReplicationTaskResponse;", "getStatus", "setReplicationMetadata", "opensearch-cross-cluster-replication"})
public final class AutoFollowTask
extends CrossClusterReplicationTask {
    @NotNull
    private final AutoFollowParams params;
    @NotNull
    private final String leaderAlias;
    @NotNull
    private final String patternName;
    @NotNull
    private final String followerIndexName;
    private final Logger log;
    @NotNull
    private Set<String> trackingIndicesOnTheCluster;
    @NotNull
    private ConcurrentSkipListSet<String> replicationJobsQueue;
    @Nullable
    private Scheduler.ScheduledCancellable retryScheduler;
    public AutoFollowStat stat;

    public AutoFollowTask(long id, @NotNull String type, @NotNull String action, @NotNull String description, @NotNull TaskId parentTask, @NotNull Map<String, String> headers, @NotNull String executor, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager, @NotNull AutoFollowParams params, @NotNull ReplicationSettings replicationSettings) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)parentTask, (String)"parentTask");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        super(id, type, action, description, parentTask, headers, executor, clusterService, threadPool, client, replicationMetadataManager, replicationSettings);
        this.params = params;
        this.leaderAlias = this.params.getLeaderCluster();
        this.patternName = this.params.getPatternName();
        this.followerIndexName = this.params.getPatternName();
        String[] stringArray = new String[]{this.getLeaderAlias()};
        this.log = Loggers.getLogger(((Object)((Object)this)).getClass(), (String[])stringArray);
        this.trackingIndicesOnTheCluster = SetsKt.emptySet();
        this.replicationJobsQueue = new ConcurrentSkipListSet();
    }

    @NotNull
    public final AutoFollowParams getParams() {
        return this.params;
    }

    @Override
    @NotNull
    protected String getLeaderAlias() {
        return this.leaderAlias;
    }

    @NotNull
    public final String getPatternName() {
        return this.patternName;
    }

    @Override
    @NotNull
    protected String getFollowerIndexName() {
        return this.followerIndexName;
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }

    @NotNull
    public final AutoFollowStat getStat() {
        AutoFollowStat autoFollowStat = this.stat;
        if (autoFollowStat != null) {
            return autoFollowStat;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stat");
        return null;
    }

    public final void setStat(@NotNull AutoFollowStat autoFollowStat) {
        Intrinsics.checkNotNullParameter((Object)autoFollowStat, (String)"<set-?>");
        this.stat = autoFollowStat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object execute(@NotNull CoroutineScope scope, @Nullable PersistentTaskState initialState, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.setStat(new AutoFollowStat(this.params.getPatternName(), this.getReplicationMetadata().getLeaderContext().getResource()));
lbl13:
                // 5 sources

                while (CoroutineScopeKt.isActive((CoroutineScope)scope)) {
                    this.addRetryScheduler();
                    $continuation.L$0 = scope;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)initialState);
                    $continuation.L$2 = null;
                    $continuation.label = 1;
                    v0 = this.pollForIndices((Continuation<? super Unit>)$continuation);
                    ** if (v0 != var8_6) goto lbl24
lbl23:
                    // 1 sources

                    return var8_6;
lbl24:
                    // 1 sources

                    ** GOTO lbl33
                }
                break;
            }
            case 1: {
                initialState = (PersistentTaskState)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                this.getStat().setLastExecutionTime(System.currentTimeMillis());
                $continuation.L$0 = scope;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)initialState);
                $continuation.label = 2;
                v1 = DelayKt.delay((long)this.getReplicationSettings().getAutofollowFetchPollDuration().getMillis(), (Continuation)$continuation);
                if (v1 != var8_6) ** GOTO lbl13
                return var8_6;
            }
            case 2: {
                initialState = (PersistentTaskState)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl13
                }
                catch (OpenSearchException e) {
                    status = e.status().getStatus();
                    if (status < 500 && status != RestStatus.TOO_MANY_REQUESTS.getStatus()) {
                        this.getLog().error("Exiting autofollow task", (Throwable)e);
                        throw e;
                    }
                    this.getLog().debug("Encountered transient error while running autofollow task", (Throwable)e);
                    $continuation.L$0 = scope;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)initialState);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                    $continuation.I$0 = status;
                    $continuation.label = 3;
                    v2 = DelayKt.delay((long)this.getReplicationSettings().getAutofollowFetchPollDuration().getMillis(), (Continuation)$continuation);
                    if (v2 != var8_6) ** GOTO lbl13
                    return var8_6;
                }
            }
            case 3: {
                status = $continuation.I$0;
                e = (OpenSearchException)$continuation.L$2;
                initialState = (PersistentTaskState)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl13
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void addRetryScheduler() {
        this.getLog().debug("Adding retry scheduler");
        if (this.retryScheduler != null) {
            Scheduler.ScheduledCancellable scheduledCancellable = this.retryScheduler;
            Intrinsics.checkNotNull((Object)scheduledCancellable);
            if (scheduledCancellable.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                return;
            }
        }
        try {
            this.retryScheduler = this.getThreadPool().schedule(() -> AutoFollowTask.addRetryScheduler$lambda$0(this), this.getReplicationSettings().getAutofollowRetryPollDuration(), "same");
        }
        catch (Exception e) {
            this.getLog().error("Error scheduling retry on failed autofollow indices " + ExtensionsKt.stackTraceToString(e));
            this.retryScheduler = null;
        }
    }

    @Override
    @Nullable
    protected Object cleanup(@NotNull Continuation<? super Unit> $completion) {
        block0: {
            Scheduler.ScheduledCancellable scheduledCancellable = this.retryScheduler;
            if (scheduledCancellable == null) break block0;
            Boxing.boxBoolean((boolean)scheduledCancellable.cancel());
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object pollForIndices(Continuation<? super Unit> $completion) {
        if (!($completion instanceof pollForIndices.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AutoFollowTask.access$pollForIndices(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().debug("Checking " + this.getLeaderAlias() + " under pattern name " + this.patternName + " for new indices to auto follow");
                entry = this.getReplicationMetadata().getLeaderContext().getResource();
                remoteIndices = new Iterable<String>(){

                    public Iterator<String> iterator() {
                        boolean bl = false;
                        return ArrayIteratorKt.iterator((Object[])new String[0]);
                    }
                };
                remoteClient = this.getClient().getRemoteClusterClient(this.getLeaderAlias());
                var6_11 /* !! */  = new GetIndexRequest.Feature[]{};
                v0 = new GetIndexRequest().features(Arrays.copyOf(var6_11 /* !! */ , var6_11 /* !! */ .length));
                var6_11 /* !! */  = new String[]{entry};
                indexReq = (GetIndexRequest)((GetIndexRequest)v0.indices((String[])var6_11 /* !! */ )).indicesOptions(IndicesOptions.lenientExpandOpen());
                Intrinsics.checkNotNull((Object)remoteClient);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)entry);
                $continuation.L$1 = remoteIndices;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)remoteClient);
                $continuation.L$3 = indexReq;
                $continuation.label = 1;
                v1 = CoroutinesKt.suspending$default(remoteClient, (Function2)new Function2<GetIndexRequest, ActionListener<GetIndexResponse>, Unit>((Object)remoteClient.admin().indices()){

                    public final void invoke(GetIndexRequest p0, ActionListener<GetIndexResponse> p1) {
                        ((IndicesAdminClient)this.receiver).getIndex(p0, p1);
                    }
                }, true, false, (Continuation)$continuation, 4, null);
                ** if (v1 != var11_4) goto lbl31
lbl30:
                // 1 sources

                return var11_4;
lbl31:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                indexReq = (GetIndexRequest)$continuation.L$3;
                remoteClient = (Client)$continuation.L$2;
                remoteIndices = (Iterable)$continuation.L$1;
                entry = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)entry);
                $continuation.L$1 = remoteIndices;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)remoteClient);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)indexReq);
                $continuation.label = 2;
                v2 = ((Function2)v1).invoke((Object)indexReq, (Object)$continuation);
                ** if (v2 != var11_4) goto lbl49
lbl48:
                // 1 sources

                return var11_4;
lbl49:
                // 1 sources

                ** GOTO lbl59
            }
            case 2: {
                indexReq = (GetIndexRequest)$continuation.L$3;
                remoteClient = (Client)$continuation.L$2;
                remoteIndices = (Iterable)$continuation.L$1;
                entry = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl59:
                    // 2 sources

                    response = (GetIndexResponse)v2;
                    v3 = response.getIndices();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getIndices(...)");
                    remoteIndices = ArraysKt.asIterable((Object[])v3);
                }
                catch (Exception e) {
                    if (this.getStat().getFailedLeaderCall() >= 0L && this.getStat().getFailedLeaderCall() % (long)10 == 0L) {
                        this.getLog().error("Fetching remote indices failed with error - " + ExtensionsKt.stackTraceToString(e));
                    }
                    var6_12 = this.getStat();
                    var7_15 = var6_12.getFailedLeaderCall();
                    var6_12.setFailedLeaderCall(var7_15 + 1L);
                }
                v4 = this.getClusterService().state().metadata().getConcreteAllIndices();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getConcreteAllIndices(...)");
                currentIndices = ArraysKt.asIterable((Object[])v4);
                if (((Collection)CollectionsKt.intersect((Iterable)remoteIndices, (Iterable)currentIndices)).isEmpty() == false && !Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)currentIndices), this.trackingIndicesOnTheCluster)) {
                    this.getLog().info("Cannot initiate replication for the following indices from leader (" + this.getLeaderAlias() + ") as indices with same name already exists on the cluster " + CollectionsKt.intersect((Iterable)remoteIndices, (Iterable)currentIndices));
                    this.trackingIndicesOnTheCluster = CollectionsKt.toSet((Iterable)currentIndices);
                }
                remoteIndices = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)remoteIndices, (Iterable)currentIndices), (Iterable)this.getStat().getFailedIndices()), (Iterable)this.replicationJobsQueue);
                this.getStat().setFailCounterForRun(0L);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)entry);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)remoteIndices);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)currentIndices);
                $continuation.L$3 = null;
                $continuation.label = 3;
                v5 = this.startReplicationJobs(remoteIndices, (Continuation<? super Unit>)$continuation);
                if (v5 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl93
            }
            case 3: {
                currentIndices = (Iterable)$continuation.L$2;
                remoteIndices = (Iterable)$continuation.L$1;
                entry = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl93:
                // 2 sources

                this.getStat().setFailCount(this.getStat().getFailCounterForRun());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object startReplicationJobs(Iterable<String> remoteIndices, Continuation<? super Unit> $completion) {
        block15: {
            if (!($completion instanceof startReplicationJobs.1)) ** GOTO lbl-1000
            var9_3 = $completion;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ AutoFollowTask this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AutoFollowTask.access$startReplicationJobs(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    completedJobs = new ConcurrentSkipListSet();
                    v0 = this.replicationJobsQueue.iterator();
                    Intrinsics.checkNotNullExpressionValue(v0, (String)"iterator(...)");
                    var4_7 = v0;
lbl16:
                    // 4 sources

                    while (var4_7.hasNext()) {
                        index = var4_7.next();
                        Intrinsics.checkNotNull((Object)index);
                        statusReq = new ShardInfoRequest(index, false);
                        $continuation.L$0 = remoteIndices;
                        $continuation.L$1 = completedJobs;
                        $continuation.L$2 = var4_7;
                        $continuation.L$3 = index;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)statusReq);
                        $continuation.label = 1;
                        v1 = CoroutinesKt.suspendExecute$default((OpenSearchClient)this.getClient(), ReplicationStatusAction.Companion.getINSTANCE(), (ActionRequest)statusReq, true, false, (Continuation)$continuation, 8, null);
                        ** if (v1 != var10_5) goto lbl31
lbl30:
                        // 1 sources

                        return var10_5;
lbl31:
                        // 1 sources

                        ** GOTO lbl43
                    }
                    break;
                }
                case 1: {
                    statusReq = (ShardInfoRequest)$continuation.L$4;
                    index = (String)$continuation.L$3;
                    var4_7 = (Iterator<String>)$continuation.L$2;
                    completedJobs = (ConcurrentSkipListSet)$continuation.L$1;
                    remoteIndices = (Iterable)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl43:
                        // 2 sources

                        if (Intrinsics.areEqual((Object)(statusRes = (ReplicationStatusResponse)v1).getStatus(), (Object)"BOOTSTRAPPING")) ** GOTO lbl16
                        completedJobs.add(index);
                    }
                    catch (Exception ex) {
                        this.getLog().error("Error while fetching the status for index " + index, (Throwable)ex);
                    }
                    ** GOTO lbl16
                }
            }
            this.replicationJobsQueue.removeAll(completedJobs);
            concurrentJobsAllowed = this.getReplicationSettings().getAutofollowConcurrentJobsTriggerSize();
            if (this.replicationJobsQueue.size() >= concurrentJobsAllowed) {
                this.getLog().debug("Max concurrent replication jobs already in the queue for autofollow task[" + this.params.getPatternName() + "]");
                return Unit.INSTANCE;
            }
            totalJobsToTrigger = concurrentJobsAllowed - this.replicationJobsQueue.size();
            var6_11 = remoteIndices.iterator();
lbl58:
            // 2 sources

            while (var6_11.hasNext()) {
                newRemoteIndex = (String)var6_11.next();
                if (totalJobsToTrigger <= 0) break block15;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)remoteIndices);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)completedJobs);
                $continuation.L$2 = var6_11;
                $continuation.L$3 = newRemoteIndex;
                $continuation.L$4 = null;
                $continuation.I$0 = concurrentJobsAllowed;
                $continuation.I$1 = totalJobsToTrigger;
                $continuation.label = 2;
                v2 = this.startReplication(newRemoteIndex, (Continuation<? super Unit>)$continuation);
                if (v2 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl83
            }
            {
                break;
                case 2: {
                    totalJobsToTrigger = $continuation.I$1;
                    concurrentJobsAllowed = $continuation.I$0;
                    newRemoteIndex = (String)$continuation.L$3;
                    var6_11 = (Iterator<T>)$continuation.L$2;
                    completedJobs = (ConcurrentSkipListSet)$continuation.L$1;
                    remoteIndices = (Iterable)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl83:
                    // 2 sources

                    this.replicationJobsQueue.add(newRemoteIndex);
                    --totalJobsToTrigger;
                    ** GOTO lbl58
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object startReplication(String leaderIndex, Continuation<? super Unit> $completion) {
        if (!($completion instanceof startReplication.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AutoFollowTask.access$startReplication(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getClusterService().state().metadata().hasIndex(leaderIndex)) {
                    this.getLog().info(StringsKt.trimMargin$default((String)("Cannot replicate " + this.getLeaderAlias() + ":" + leaderIndex + " as an index with the same name already \n                        |exists."), null, (int)1, null));
                    return Unit.INSTANCE;
                }
                successStart = 0;
                this.getLog().info("Auto follow starting replication from " + this.getLeaderAlias() + ":" + leaderIndex + " -> " + leaderIndex);
                request = new ReplicateIndexRequest(leaderIndex, this.getLeaderAlias(), leaderIndex, null, 8, null);
                request.setAutoFollowRequest(true);
                v0 = this.getReplicationMetadata().getFollowerContext().getUser();
                followerRole = v0 != null && (v0 = v0.getRoles()) != null ? (String)v0.get(0) : null;
                v1 = this.getReplicationMetadata().getLeaderContext().getUser();
                v2 = v1 != null && (v1 = v1.getRoles()) != null ? (String)v1.get(0) : (leaderRole = null);
                if (followerRole != null && leaderRole != null) {
                    request.setUseRoles(new HashMap<String, String>());
                    v3 = request.getUseRoles();
                    Intrinsics.checkNotNull(v3);
                    ((Map)v3).put("follower_cluster_role", followerRole);
                    v4 = request.getUseRoles();
                    Intrinsics.checkNotNull(v4);
                    ((Map)v4).put("leader_cluster_role", leaderRole);
                }
                request.setSettings(this.getReplicationMetadata().getSettings());
                $continuation.L$0 = leaderIndex;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)followerRole);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)leaderRole);
                $continuation.I$0 = successStart;
                $continuation.label = 1;
                v5 = CoroutinesKt.suspendExecute$default((OpenSearchClient)this.getClient(), this.getReplicationMetadata(), ReplicateIndexAction.Companion.getINSTANCE(), (ActionRequest)request, false, (Continuation)$continuation, 8, null);
                ** if (v5 != var10_5) goto lbl45
lbl44:
                // 1 sources

                return var10_5;
lbl45:
                // 1 sources

                ** GOTO lbl56
            }
            case 1: {
                successStart = $continuation.I$0;
                leaderRole = (String)$continuation.L$3;
                followerRole = (String)$continuation.L$2;
                request = (ReplicateIndexRequest)$continuation.L$1;
                leaderIndex = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl56:
                    // 2 sources

                    if (!(response = (ReplicateIndexResponse)v5).isAcknowledged()) {
                        throw new ReplicationException("Failed to auto follow leader index " + leaderIndex, new Object[0]);
                    }
                    successStart = 1;
                    this.getLog().debug("Auto follow has started replication from " + this.getLeaderAlias() + ":" + leaderIndex + " -> " + leaderIndex);
                }
                catch (OpenSearchSecurityException e) {
                    this.getLog().trace("Cannot start replication on " + leaderIndex + " due to missing permissions " + e);
                    if (successStart == 0) ** GOTO lbl76
                    e = this.getStat();
                    var5_17 = e.getSuccessCount();
                    e.setSuccessCount(var5_17 + 1L);
                    v6 = this.getStat().getFailedIndices().remove(leaderIndex);
                    ** GOTO lbl107
lbl76:
                    // 1 sources

                    e = this.getStat();
                    var5_18 = e.getFailCounterForRun();
                    e.setFailCounterForRun(var5_18 + 1L);
                    v6 = this.getStat().getFailedIndices().add(leaderIndex);
                    ** GOTO lbl107
                }
                catch (Exception e) {
                    this.getLog().warn("Failed to start replication for " + this.getLeaderAlias() + ":" + leaderIndex + " -> " + leaderIndex + ".", (Throwable)e);
                    if (successStart == 0) ** GOTO lbl90
                    var4_12 = this.getStat();
                    var5_19 = var4_12.getSuccessCount();
                    var4_12.setSuccessCount(var5_19 + 1L);
                    v7 = this.getStat().getFailedIndices().remove(leaderIndex);
                    ** GOTO lbl107
lbl90:
                    // 1 sources

                    var4_13 = this.getStat();
                    var5_20 = var4_13.getFailCounterForRun();
                    var4_13.setFailCounterForRun(var5_20 + 1L);
                    v7 = this.getStat().getFailedIndices().add(leaderIndex);
                    {
                        catch (Throwable var4_14) {
                            if (successStart != 0) {
                                var5_15 = this.getStat();
                                var6_23 = var5_15.getSuccessCount();
                                var5_15.setSuccessCount(var6_23 + 1L);
                                v8 = this.getStat().getFailedIndices().remove(leaderIndex);
                            } else {
                                var5_15 = this.getStat();
                                var6_24 = var5_15.getFailCounterForRun();
                                var5_15.setFailCounterForRun(var6_24 + 1L);
                                v8 = this.getStat().getFailedIndices().add(leaderIndex);
                            }
                            throw var4_14;
                        }
                    }
                }
                request = this.getStat();
                var5_16 = request.getSuccessCount();
                request.setSuccessCount(var5_16 + 1L);
                this.getStat().getFailedIndices().remove(leaderIndex);
lbl107:
                // 5 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public String toString() {
        return "AutoFollowTask(from=" + this.getLeaderAlias() + " with pattern=" + this.params.getPatternName() + ")";
    }

    @Override
    @NotNull
    protected CrossClusterReplicationTask.CrossClusterReplicationTaskResponse replicationTaskResponse() {
        return new CrossClusterReplicationTask.CrossClusterReplicationTaskResponse("COMPLETED");
    }

    @NotNull
    public AutoFollowStat getStatus() {
        return this.getStat();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object setReplicationMetadata(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof setReplicationMetadata.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.setReplicationMetadata((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = this.getReplicationMetadataManager().getAutofollowMetadata(this.getFollowerIndexName(), this.getLeaderAlias(), true, (Continuation<? super ReplicationMetadata>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                var2_5 = (AutoFollowTask)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                var2_5.setReplicationMetadata((ReplicationMetadata)v0);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void addRetryScheduler$lambda$0(AutoFollowTask this$0) {
        this$0.getLog().debug("Clearing failed indices to schedule for the next retry");
        this$0.getStat().getFailedIndices().clear();
    }

    public static final /* synthetic */ Object access$pollForIndices(AutoFollowTask $this, Continuation $completion) {
        return $this.pollForIndices((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$startReplicationJobs(AutoFollowTask $this, Iterable remoteIndices, Continuation $completion) {
        return $this.startReplicationJobs(remoteIndices, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$startReplication(AutoFollowTask $this, String leaderIndex, Continuation $completion) {
        return $this.startReplication(leaderIndex, (Continuation<? super Unit>)$completion);
    }
}

