/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.InternalEngine;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/replication/ReplicationEngine;", "Lorg/opensearch/index/engine/InternalEngine;", "config", "Lorg/opensearch/index/engine/EngineConfig;", "<init>", "(Lorg/opensearch/index/engine/EngineConfig;)V", "assertPrimaryIncomingSequenceNumber", "", "origin", "Lorg/opensearch/index/engine/Engine$Operation$Origin;", "seqNo", "", "generateSeqNoForOperationOnPrimary", "operation", "Lorg/opensearch/index/engine/Engine$Operation;", "indexingStrategyForOperation", "Lorg/opensearch/index/engine/InternalEngine$IndexingStrategy;", "index", "Lorg/opensearch/index/engine/Engine$Index;", "deletionStrategyForOperation", "Lorg/opensearch/index/engine/InternalEngine$DeletionStrategy;", "delete", "Lorg/opensearch/index/engine/Engine$Delete;", "assertNonPrimaryOrigin", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nReplicationEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationEngine.kt\norg/opensearch/replication/ReplicationEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class ReplicationEngine
extends InternalEngine {
    public ReplicationEngine(@NotNull EngineConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
    }

    protected boolean assertPrimaryIncomingSequenceNumber(@NotNull Engine.Operation.Origin origin, long seqNo) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        boolean bl2 = bl = origin == Engine.Operation.Origin.PRIMARY;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ReplicationEngine$assertPrimaryIncomingSequenceNumber$32 = false;
            String $i$a$-assert-ReplicationEngine$assertPrimaryIncomingSequenceNumber$32 = "Expected origin PRIMARY for replicated ops but was " + origin;
            throw new AssertionError((Object)$i$a$-assert-ReplicationEngine$assertPrimaryIncomingSequenceNumber$32);
        }
        boolean bl3 = bl = seqNo != -2L;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Expected valid sequence number for replicated op but was unassigned";
            throw new AssertionError((Object)string);
        }
        return true;
    }

    protected long generateSeqNoForOperationOnPrimary(@NotNull Engine.Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (!(operation.seqNo() != -2L)) {
            boolean bl = false;
            String string = "Expected valid sequence number for replicate op but was unassigned";
            throw new IllegalStateException(string.toString());
        }
        return operation.seqNo();
    }

    @NotNull
    protected InternalEngine.IndexingStrategy indexingStrategyForOperation(@NotNull Engine.Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        InternalEngine.IndexingStrategy indexingStrategy = this.planIndexingAsNonPrimary(index);
        Intrinsics.checkNotNullExpressionValue((Object)indexingStrategy, (String)"planIndexingAsNonPrimary(...)");
        return indexingStrategy;
    }

    @NotNull
    protected InternalEngine.DeletionStrategy deletionStrategyForOperation(@NotNull Engine.Delete delete) {
        Intrinsics.checkNotNullParameter((Object)delete, (String)"delete");
        InternalEngine.DeletionStrategy deletionStrategy = this.planDeletionAsNonPrimary(delete);
        Intrinsics.checkNotNullExpressionValue((Object)deletionStrategy, (String)"planDeletionAsNonPrimary(...)");
        return deletionStrategy;
    }

    protected boolean assertNonPrimaryOrigin(@NotNull Engine.Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return true;
    }
}

