/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;

public abstract class SessionEntity {
    private String realmId;
    private boolean isOffline;

    @ProtoField(value=1)
    @Basic
    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public SessionEntity() {
    }

    protected SessionEntity(String realmId) {
        this.realmId = realmId;
    }

    @Deprecated(since="26.4", forRemoval=true)
    public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
        if (localEntityWrapper == null) {
            return new SessionEntityWrapper<SessionEntity>(this);
        }
        return new SessionEntityWrapper<SessionEntity>(localEntityWrapper.getLocalMetadata(), this);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean isOffline() {
        if (!MultiSiteUtils.isPersistentSessionsEnabled()) {
            throw new IllegalArgumentException("Offline flags are not supported in non-persistent-session environments.");
        }
        return this.isOffline;
    }

    public void setOffline(boolean offline) {
        if (!MultiSiteUtils.isPersistentSessionsEnabled()) {
            throw new IllegalArgumentException("Offline flags are not supported in non-persistent-session environments.");
        }
        this.isOffline = offline;
    }

    public boolean shouldEvaluateRemoval() {
        return false;
    }
}

