/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.mirror.Heartbeat;
import org.apache.kafka.connect.mirror.MirrorHeartbeatConfig;
import org.apache.kafka.connect.mirror.MirrorHeartbeatConnector;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;

public class MirrorHeartbeatTask
extends SourceTask {
    private String sourceClusterAlias;
    private String targetClusterAlias;
    private String heartbeatsTopic;
    private Duration interval;
    private CountDownLatch stopped;

    public void start(Map<String, String> props) {
        this.stopped = new CountDownLatch(1);
        MirrorHeartbeatConfig config = new MirrorHeartbeatConfig(props);
        this.sourceClusterAlias = config.sourceClusterAlias();
        this.targetClusterAlias = config.targetClusterAlias();
        this.heartbeatsTopic = config.heartbeatsTopic();
        this.interval = config.emitHeartbeatsInterval();
    }

    public void commit() {
    }

    public void stop() {
        this.stopped.countDown();
    }

    public String version() {
        return new MirrorHeartbeatConnector().version();
    }

    public List<SourceRecord> poll() throws InterruptedException {
        if (this.stopped.await(this.interval.toMillis(), TimeUnit.MILLISECONDS)) {
            return null;
        }
        long timestamp = System.currentTimeMillis();
        Heartbeat heartbeat = new Heartbeat(this.sourceClusterAlias, this.targetClusterAlias, timestamp);
        SourceRecord record = new SourceRecord(heartbeat.connectPartition(), MirrorUtils.wrapOffset(0L), this.heartbeatsTopic, Integer.valueOf(0), Schema.BYTES_SCHEMA, (Object)heartbeat.recordKey(), Schema.BYTES_SCHEMA, (Object)heartbeat.recordValue(), Long.valueOf(timestamp));
        return Collections.singletonList(record);
    }

    public void commitRecord(SourceRecord record, RecordMetadata metadata) {
    }
}

