---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token HashiCorp Vault batch token'
---

## Description

The response body contains content that matches the pattern of a HashiCorp Vault batch token was identified. Batch tokens are used when hundreds to thousands of systems need to access Vault but generating unique tokens would not scale. These tokens are usually short lived and bound to a specific vault policy. A malicious actor with access to this token can impersonate a service and would have the same permission levels as the policy that the batch token is created for.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). Batch tokens cannot be revoked so you should use very short "time to live" values when creating batch tokens. For more information, please see [Vault's documentation on batch tokens](https://developer.hashicorp.com/vault/tutorials/tokens/batch-tokens).

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.154 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
