---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: タイムトラッキング
description: 見積もり、費やした時間、レポート。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.0で、タスクのタイムトラッキングが[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/438577)。
- GitLab 17.5で、エピックのタイムトラッキングが[導入されました](https://gitlab.com/groups/gitlab-org/-/epics/12396)。[エピックの新しい外観](../group/epics/_index.md#epics-as-work-items)を有効にする必要があります。
- GitLab 17.7で、見積もりを追加、編集、削除するための最小ロールがレポーターからプランナーに[変更されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)。
- エピックのタイムトラッキングは、GitLab 18.1で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/468310)されています。

{{< /history >}}

タイムトラッキングは、GitLabの作業アイテムに費やした時間を記録および管理するのに役立ちます。タイムトラッキング:

- イシュー、マージリクエスト、エピック、タスクに費やされた実際の時間を記録します。
- 完了に必要な合計時間を見積もります。
- 時間エントリの詳細なレポートを提供します。
- 標準化された時間単位を使用して合計を計算します。
- クイックアクションとUIを通じて履歴を追跡します。

作業項目の右側のサイドバーにタイムトラッキング情報を表示できます:

![サイドバーのタイムトラッキング](img/time_tracking_sidebar_v18_3.png)

[クイックアクション](quick_actions.md)またはUIを使用して、タイムトラッキングデータを入力および削除します。独自の行にクイックアクションを入力します。1つのコメントで同じクイックアクションを複数回使用した場合、最後に実行されたアクションのみが適用されます。

## 権限 {#permissions}

ロールに応じて、さまざまなタイムトラッキング機能を利用できます:

- 見積もりを追加、編集、削除するには、イシューとタスクの場合はプランナーロール、マージリクエストの場合はデベロッパーロールが少なくとも必要です。
- 費やした時間を追加および編集するには、プロジェクトのプランナーロールが少なくとも必要です。
- 時間エントリを削除するには、作成者であるか、少なくともメンテナーロールを保持している必要があります。

## 見積もり {#estimates}

見積もりは、アイテムを完了するために必要な合計時間を示すように設計されています。

右側のサイドバーにあるタイムトラッキング情報にカーソルを合わせると、残り予測時間を確認できます。

![残り見積もり時間](img/remaining_time_v18_3.png)

### 見積もりを追加する {#add-an-estimate}

前提要件:

- イシューでは、少なくともプロジェクトのプランナーロールが必要です。
- タスクでは、少なくともプロジェクトのプランナーロールが必要です。
- マージリクエストでは、少なくともプロジェクトのデベロッパーロールが必要です。

見積もりを入力するには、`/estimate` [クイックアクション](quick_actions.md)の後に時間を入力します。

たとえば、1か月、2週間、3日、4時間、5分の見積もりを入力する必要がある場合は、`/estimate 1mo 2w 3d 4h 5m`と入力します。[使用できる時間単位](#available-time-units)を確認してください。

1つのアイテムに設定できる見積もりは1つのみです。新しい時間見積もりを入力するたびに、以前の値が上書きされます。

### 見積もりを削除する {#remove-an-estimate}

前提要件:

- イシューでは、少なくともプロジェクトのプランナーロールが必要です。
- タスクでは、少なくともプロジェクトのプランナーロールが必要です。
- マージリクエストでは、少なくともプロジェクトのデベロッパーロールが必要です。

見積もりを完全に削除するには、`/remove_estimate` [クイックアクション](quick_actions.md)を使用します。

## 費やした時間 {#time-spent}

作業中に費やした時間を記録できます。

新しい時間の入力ごとに、イシュー、タスク、またはマージリクエストの現在の合計時間に追加されます。

イシュー、タスク、またはマージリクエストに費やした合計時間は、1年を超えることはできません。

### 費やした時間を追加する {#add-time-spent}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

#### ユーザーインターフェースを使用する {#using-the-user-interface}

{{< history >}}

- GitLab 15.7で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/101563)。
- GitLab 17.0で[変更されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150564)。どのタイミングで時間が費やされたかを指定しない場合、現在の時間が使用されます。

{{< /history >}}

UIを使用して時間エントリを追加するには、次の手順に従います:

1. サイドバーの**タイムトラッキング**セクションで、**時間エントリを追加**（{{< icon name="plus" >}}）を選択します。ダイアログが開きます。
1. 次を入力します:

   - 費やした時間。
   - オプション。どのタイミングで時間が費やされたか。空の場合、現在の時間を使用します。
   - オプション。概要。

1. **保存**を選択します。

サイドバーの**費やした時間**の合計が更新され、[タイムトラッキングレポート](#view-an-items-time-tracking-report)ですべてのエントリを表示できます。

#### クイックアクションを使用する {#using-a-quick-action}

費やした時間を入力するには、`/spend` [クイックアクション](quick_actions.md)の後に時間を入力します。

たとえば、1か月、2週間、3日、4時間、5分を記録する必要がある場合は、`/spend 1mo 2w 3d 4h 5m`と入力します。[使用できる時間単位](#available-time-units)を確認してください。

ノートを含む[タイムトラッキングレポート](#view-an-items-time-tracking-report)エントリを追加するには、説明とクイックアクションを含むコメントを作成します。タイムトラッキングレポートの**Summary/Notes**（サマリー/ノート）列に表示されます。次に例を示します:

```plaintext
Draft MR and respond to initial comments

/spend 30m
```

時間が費やされた日時を記録するには、`YYYY-MM-DD`形式を使用して、時間の後に日付を入力します。

たとえば、2021年1月31日に費やした1時間を記録するには、`/spend 1h 2021-01-31`と入力します。

将来の日付を入力しても、時間は記録されません。

#### コミットメッセージの使用 {#using-commit-messages}

{{< history >}}

- GitLab 18.3で`commit_time_tracking`フラグであるとともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/16543)。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

イシューに費やした時間をコミットメッセージに直接記録できます。この方法は、イシューを別途更新せずに、作業中に時間を追跡したい場合に便利です。

コミットメッセージに費やした時間を追加するには、時間単位の間にスペースを入れずに、`@<time>`の形式でイシューの参照とタイムトラッキングマーカーを含めます。

次に例を示します: 

```plaintext
Fix a bug in the login form #123 @1mo2d3h15m
```

このコミットメッセージは、イシュー#123に1か月、2日、3時間、15分の時間を費やしたことを追加します。

タイムトラッキングマーカーは次のとおりである必要があります:

- `@`記号で始まる。
- その後に時間単位をスペースなしですぐに続ける。
- 次の時間単位をサポートします: 月（`mo`）、日（`d`）、時間（`h`）、分（`m`）、秒（`s`）。
- 通常のタイムトラッキングと同じ[時間単位](#available-time-units)を使用します。

タイムトラッキング情報を含むコミットをプッシュすると:

1. GitLabは、コミットメッセージから費やされた時間を抽出します。
1. 時間は、同じコミットメッセージで参照されているすべてのイシューに追加されます。
1. コミットから時間が追加されたことを示すシステムノートがイシューに追加されます。
1. タイムトラッキングエントリには、コミットSHAとタイトルが説明として含まれています。

##### コミットの作成者の権限 {#commit-author-permissions}

コミットの作成者がイシューの更新権限を持っている場合にのみ、コミットメッセージからイシューに時間が追加されます:

- コミットの作成者は、イシューが存在するプロジェクトのプランナーロール以上を持っている必要があります。
- 作成者が十分な権限を持っていない場合、コミットのタイムトラッキング情報は無視されます。
- 権限チェックでは、通常のタイムトラッキングと同じルールが使用されます。

##### 既知の問題 {#known-issues}

**Multiple time amounts in one commit**（1つのコミットに複数の時間量）

コミットメッセージが異なる時間量で複数のイシューを参照する場合、最初の時間量のみが参照されているすべてのイシューに適用されます。

たとえば、次のコミットメッセージ:

```plaintext
Fixes #41 @1h30m and fixes #40 @2h
```

イシュー#41とイシュー#40の両方に1時間30分を追加します。2番目の時間量（`@2h`）は無視されます。

**Duplicate time entries from commit SHA changes**（コミットSHAの変更によるタイムエントリの重複）

コミットのSHAが変更された場合（たとえば、リベースまたは修正後）、GitLabはそれをタイムトラッキングの新しいコミットとして扱います。これにより、元のコミットと新しいコミットの両方がイシューで参照されている場合に、タイムエントリが重複する可能性があります。

コミットSHAが変更される可能性がある場合にタイムエントリの重複を避けるには:

- コミットメッセージの代わりに、UIまたはクイックアクションを使用して、イシューに直接時間を追加します。
- タイムトラッキングにコミットメッセージを使用する必要がある場合は、ブランチの履歴が確定した後でのみ時間を追加してください。
- マージする前に、イシューのタイムトラッキングレポートをチェックして、重複の可能性を特定して削除してください。

### マージリクエストでのタイムトラッキングの重複を防止 {#prevent-duplicate-time-tracking-in-merge-requests}

タイムトラッキング情報を含むコミットを含むマージリクエストをマージすると、GitLabはタイムトラッキングの重複を防止します:

- 時間がリポジトリの履歴に複数回表示されるコミットメッセージであっても、コミットごとに1回のみ時間が追跡されます。
- GitLabは、同じコミットタイトルとIDを持つタイムエントリがイシューに既に存在するかどうかをチェックすることにより、タイムトラッキングの重複を防止します。
- コミットがマージされると、追加の時間は追跡されません。これにより、フィーチャーブランチがデフォルトブランチにマージされるときに、時間が二重にカウントされるのを防ぎます。

### 費やした時間を差し引く {#subtract-time-spent}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

時間を差し引くには、負の値を入力します。たとえば、`/spend -3d`は、費やした合計時間から3日を削除します。費やした時間が0分を下回ることはないため、既に入力した時間よりも多くの時間を削除しようとすると、GitLabはその減算を無視します。

### 費やした時間を削除する {#delete-time-spent}

{{< history >}}

- GitLab 15.1で削除ボタンが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/356796)されました。

{{< /history >}}

タイムログは、費やした時間の単一のエントリであり、正または負です。

前提要件:

- タイムログの作成者であるか、少なくともプロジェクトのメンテナーロールを持っている必要があります。

タイムログを削除するには、次のいずれかを実行します:

- タイムトラッキングレポートで、タイムログエントリの右側にある**費やした時間を削除**（{{< icon name="remove" >}}）を選択します。
- [GraphQL API](../../api/graphql/reference/_index.md#mutationtimelogdelete)を使用します。

### 費やしたすべての時間を削除する {#delete-all-the-time-spent}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

費やしたすべての時間を一度に削除するには、`/remove_time_spent` [クイックアクション](quick_actions.md)を使用します。

## アイテムのタイムトラッキングレポートを表示する {#view-an-items-time-tracking-report}

アイテムに費やした時間のタイムトラッキングレポートを表示するには、次の手順に従います:

- 右側のサイドバーで、**費やした時間**の横にある時間を選択してください。

![タイムトラッキングレポート](img/time_tracking_report_v18_3.png)

表示される費やされた時間の内訳は、最大100エントリに制限されています。

## グローバルタイムトラッキングレポート {#global-time-tracking-report}

{{< details >}}

- ステータス: 実験的機能

{{< /details >}}

{{< history >}}

- GitLab 15.11で`global_time_tracking_report`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/344002)されました。デフォルトでは無効になっています。
- GitLab 16.5のGitLab.comで有効になりました。

{{< /history >}}

{{< alert type="flag" >}}

GitLab Self-Managedでは、デフォルトでこの機能は使用できません。管理者が`global_time_tracking_report`という名前の[機能フラグを有効にする](../../administration/feature_flags/_index.md)と、この機能を使用できるようになります。GitLab.comでは、この機能を利用できます。GitLab Dedicatedでは、この機能は利用できません。この機能は本番環境での使用には対応していません。

{{< /alert >}}

GitLab全体のイシュー、タスク、およびマージリクエストで費やされた時間のレポートを表示します。

これは[実験的機能](../../policy/development_stages_support.md)です。バグを見つけた場合は、[フィードバック](https://gitlab.com/gitlab-org/gitlab/-/issues/435222)イシューでお知らせください。

グローバルタイムトラッキングレポートを表示するには、次の手順に従います:

1. ブラウザにグローバルレポートのURLを入力します:
   - GitLab Self-Managedの場合は、ベースURLに`/-/timelogs`を追加します。たとえば、`https://gitlab.example.com/-/timelogs`です。
   - GitLab.comの場合は、<https://gitlab.com/-/timelogs>に移動します。
1. オプション。特定のユーザーでフィルター処理するには、`@`記号なしでユーザー名を入力します。
1. 開始日と終了日を選択します。
1. **レポートの実行**を選択します。

![グローバルタイムトラッキングレポート](img/global_time_report_v16_5.png)

## 利用可能な時間単位 {#available-time-units}

次の時間単位を使用できます:

| 時間単位 | 入力内容                | 換算レート |
| --------- | --------------------------- | --------------- |
| 月     | `mo`、`month`、または`months`  | 4 w（160 h）     |
| 週      | `w`、`week`、または`weeks`     | 5 d（40 h）      |
| 日       | `d`、`day`、または`days`       | 8 h             |
| 時間      | `h`、`hour`、または`hours`     | 60 m            |
| 分    | `m`、`minute`、または`minutes` |                 |

### 表示される単位を時間に制限する {#limit-displayed-units-to-hours}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLab Self-Managedでは、時間単位の表示を時間に制限できます。これを行うには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **設定** > **設定**を選択します。
1. **ローカライズ**を展開します。
1. **タイムトラッキング**で、**Limit display of time tracking units to hours**（タイムトラッキング単位の表示を時間に制限する）チェックボックスをオンにします。
1. **変更を保存**を選択します。

このオプションを有効にすると、`75h`の代わりに`1w 4d 3h`が表示されます。

## 関連トピック {#related-topics}

- タイムトラッキングGraphQLリファレンス:
  - [接続](../../api/graphql/reference/_index.md#timelogconnection)
  - [エッジ](../../api/graphql/reference/_index.md#timelogedge)
  - [フィールド](../../api/graphql/reference/_index.md#timelog)
  - [タイムログ](../../api/graphql/reference/_index.md#querytimelogs)
  - [グループタイムログ](../../api/graphql/reference/_index.md#grouptimelogs)
  - [プロジェクトタイムログ](../../api/graphql/reference/_index.md#projecttimelogs)
  - [ユーザータイムログ](../../api/graphql/reference/_index.md#usertimelogs)
