/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.database.guest.DBTracePlatformManager;
import ghidra.trace.database.guest.InternalTracePlatform;
import ghidra.trace.model.guest.TraceGuestPlatformMappedRange;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceGuestPlatformMappedRange
extends DBAnnotatedObject
implements TraceGuestPlatformMappedRange {
    public static final String TABLE_NAME = "LanguageMappings";
    static final String HOST_SPACE_COLUMN_NAME = "HostSpace";
    static final String HOST_OFFSET_COLUMN_NAME = "HostOffset";
    static final String GUEST_LANGUAGE_COLUMN_NAME = "GuestLanguage";
    static final String GUEST_SPACE_COLUMN_NAME = "GuestSpace";
    static final String GUEST_OFFSET_COLUMN_NAME = "GuestOffset";
    static final String LENGTH_COLUMN_NAME = "Length";
    @DBAnnotatedColumn(value="HostSpace")
    static DBObjectColumn HOST_SPACE_COLUMN;
    @DBAnnotatedColumn(value="HostOffset")
    static DBObjectColumn HOST_OFFSET_COLUMN;
    @DBAnnotatedColumn(value="GuestLanguage")
    static DBObjectColumn GUEST_LANGUAGE_COLUMN;
    @DBAnnotatedColumn(value="GuestSpace")
    static DBObjectColumn GUEST_SPACE_COLUMN;
    @DBAnnotatedColumn(value="GuestOffset")
    static DBObjectColumn GUEST_OFFSET_COLUMN;
    @DBAnnotatedColumn(value="Length")
    static DBObjectColumn LENGTH_COLUMN;
    @DBAnnotatedField(column="HostSpace")
    private int hostSpaceID;
    @DBAnnotatedField(column="HostOffset")
    private long hostOffset;
    @DBAnnotatedField(column="GuestLanguage")
    int guestPlatformKey;
    @DBAnnotatedField(column="GuestSpace")
    private int guestSpaceID;
    @DBAnnotatedField(column="GuestOffset")
    private long guestOffset;
    @DBAnnotatedField(column="Length")
    private long length;
    private DBTracePlatformManager manager;
    private AddressRangeImpl hostRange;
    private DBTraceGuestPlatform platform;
    private AddressRangeImpl guestRange;
    private AddressSpace hostSpace;
    private AddressSpace guestSpace;
    private long shiftHostToGuest;

    public DBTraceGuestPlatformMappedRange(DBTracePlatformManager manager, DBCachedObjectStore<?> s, DBRecord r) {
        super(s, r);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.hostSpace = this.manager.trace.getBaseAddressFactory().getAddressSpace(this.hostSpaceID);
        Address hostStart = this.hostSpace.getAddress(this.hostOffset);
        Address hostEnd = hostStart.addWrap(this.length - 1L);
        this.hostRange = new AddressRangeImpl(hostStart, hostEnd);
        InternalTracePlatform platform = this.manager.getPlatformByKey(this.guestPlatformKey);
        if (platform.isHost()) {
            throw new IOException("Table is corrupt. Got host platform in guest mapping.");
        }
        this.platform = (DBTraceGuestPlatform)platform;
        this.guestSpace = platform.getAddressFactory().getAddressSpace(this.guestSpaceID);
        Address guestStart = this.guestSpace.getAddress(this.guestOffset);
        Address guestEnd = guestStart.addWrap(this.length - 1L);
        this.guestRange = new AddressRangeImpl(guestStart, guestEnd);
        this.shiftHostToGuest = guestStart.getOffset() - hostStart.getOffset();
    }

    void set(Address hostStart, DBTraceGuestPlatform platform, Address guestStart, long length) {
        this.hostSpace = hostStart.getAddressSpace();
        this.hostSpaceID = this.hostSpace.getSpaceID();
        this.hostOffset = hostStart.getOffset();
        this.guestPlatformKey = (int)platform.getKey();
        this.guestSpace = guestStart.getAddressSpace();
        this.guestSpaceID = this.guestSpace.getSpaceID();
        this.guestOffset = guestStart.getOffset();
        this.length = length;
        this.update(new DBObjectColumn[]{HOST_SPACE_COLUMN, HOST_OFFSET_COLUMN, GUEST_LANGUAGE_COLUMN, GUEST_SPACE_COLUMN, GUEST_OFFSET_COLUMN, LENGTH_COLUMN});
        this.hostRange = new AddressRangeImpl(hostStart, hostStart.addWrap(length - 1L));
        this.platform = platform;
        this.guestRange = new AddressRangeImpl(guestStart, guestStart.addWrap(length - 1L));
        this.shiftHostToGuest = guestStart.getOffset() - hostStart.getOffset();
    }

    @Override
    public InternalTracePlatform getHostPlatform() {
        return this.manager.hostPlatform;
    }

    @Override
    public AddressRange getHostRange() {
        return this.hostRange;
    }

    @Override
    public DBTraceGuestPlatform getGuestPlatform() {
        return this.platform;
    }

    @Override
    public AddressRange getGuestRange() {
        return this.guestRange;
    }

    protected static Address doMapTo(Address address, AddressSpace space, long shift) {
        return space.getAddress(address.getOffset() + shift);
    }

    protected static AddressRange doMapTo(AddressRange range, AddressSpace space, long shift) {
        return new AddressRangeImpl(DBTraceGuestPlatformMappedRange.doMapTo(range.getMinAddress(), space, shift), DBTraceGuestPlatformMappedRange.doMapTo(range.getMaxAddress(), space, shift));
    }

    @Override
    public Address mapHostToGuest(Address hostAddress) {
        if (!this.hostRange.contains(hostAddress)) {
            return null;
        }
        return DBTraceGuestPlatformMappedRange.doMapTo(hostAddress, this.guestSpace, this.shiftHostToGuest);
    }

    @Override
    public AddressRange mapHostToGuest(AddressRange hostRange) {
        if (!this.hostRange.contains(hostRange.getMinAddress()) || !this.hostRange.contains(hostRange.getMaxAddress())) {
            return null;
        }
        return DBTraceGuestPlatformMappedRange.doMapTo(hostRange, this.guestSpace, this.shiftHostToGuest);
    }

    @Override
    public Address mapGuestToHost(Address guestAddress) {
        if (!this.guestRange.contains(guestAddress)) {
            return null;
        }
        return DBTraceGuestPlatformMappedRange.doMapTo(guestAddress, this.hostSpace, -this.shiftHostToGuest);
    }

    @Override
    public AddressRange mapGuestToHost(AddressRange guestRange) {
        if (!this.guestRange.contains(guestRange.getMinAddress()) || !this.guestRange.contains(guestRange.getMaxAddress())) {
            return null;
        }
        return DBTraceGuestPlatformMappedRange.doMapTo(guestRange, this.hostSpace, -this.shiftHostToGuest);
    }

    @Override
    public void delete(TaskMonitor monitor) throws CancelledException {
        this.platform.deleteMappedRange(this, monitor);
    }
}

