/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolDynamicInfo
extends AbstractConstantPoolInfoJava {
    private short bootstrap_method_attr_index;
    private short name_and_type_index;

    protected ConstantPoolDynamicInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.bootstrap_method_attr_index = reader.readNextShort();
        this.name_and_type_index = reader.readNextShort();
    }

    public int getBootstrapMethodAttrIndex() {
        return this.bootstrap_method_attr_index & 0xFFFF;
    }

    public int getNameAndTypeIndex() {
        return this.name_and_type_index & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_Dynamic_info";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(WORD, "bootstrap_method_attr_index", null);
        structure.add(WORD, "name_and_type_index", null);
        return structure;
    }
}

