/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import ghidra.feature.vt.api.db.TableColumn;
import ghidra.feature.vt.api.db.TableDescriptor;
import ghidra.feature.vt.api.db.VTAddressCorrelationAdapterV0;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class VTAddressCorrelatorAdapter {
    static String TABLE_NAME = "AddressCorrelationTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", AddressCorrelationTableDescriptor.INSTANCE.getColumnFields(), AddressCorrelationTableDescriptor.INSTANCE.getColumnNames());
    static int[] TABLE_INDEXES = AddressCorrelationTableDescriptor.INSTANCE.getIndexedColumns();
    private DBHandle dbHandle;

    protected VTAddressCorrelatorAdapter(DBHandle dbHandle) {
        this.dbHandle = dbHandle;
    }

    public static VTAddressCorrelatorAdapter createAdapter(DBHandle dbHandle) throws IOException {
        return new VTAddressCorrelationAdapterV0(dbHandle);
    }

    public static VTAddressCorrelatorAdapter getAdapter(DBHandle dbHandle, TaskMonitor monitor) throws VersionException {
        return new VTAddressCorrelationAdapterV0(dbHandle, monitor);
    }

    abstract void createAddressRecord(long var1, long var3, long var5) throws IOException;

    abstract List<DBRecord> getAddressRecords(long var1) throws IOException;

    void close() {
        this.dbHandle.close();
    }

    void save(TaskMonitor monitor) throws CancelledException, IOException {
        this.dbHandle.save("", null, monitor);
    }

    void saveAs(File file, TaskMonitor monitor) throws CancelledException, IOException {
        this.dbHandle.saveAs(file, true, monitor);
    }

    public static class AddressCorrelationTableDescriptor
    extends TableDescriptor {
        public static TableColumn SOURCE_ENTRY_COL = new TableColumn((Field)LongField.INSTANCE, true);
        public static TableColumn SOURCE_ADDRESS_COL = new TableColumn((Field)LongField.INSTANCE);
        public static TableColumn DESTINATION_ADDRESS_COL = new TableColumn((Field)LongField.INSTANCE);
        public static AddressCorrelationTableDescriptor INSTANCE = new AddressCorrelationTableDescriptor();
    }
}

