/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.constraint;

import generic.constraint.ConstraintData;
import ghidra.program.model.listing.Program;
import ghidra.util.constraint.ProgramConstraint;
import java.util.Objects;

public class ExecutableFormatConstraint
extends ProgramConstraint {
    private String executableFormat;

    public ExecutableFormatConstraint() {
        super("executable_format");
    }

    public boolean isSatisfied(Program program) {
        String format = program.getExecutableFormat();
        if (format == null) {
            format = "";
        }
        return this.executableFormat.equals(format);
    }

    public void loadConstraintData(ConstraintData data) {
        this.executableFormat = data.getString("name");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutableFormatConstraint)) {
            return false;
        }
        return ((ExecutableFormatConstraint)((Object)obj)).executableFormat.equals(this.executableFormat);
    }

    public int hashCode() {
        return Objects.hash(this.executableFormat);
    }

    public String getDescription() {
        return "executableFormat = " + this.executableFormat;
    }
}

