/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.LEB128;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractLeb128DataType
extends BuiltIn
implements Dynamic {
    static final FormatSettingsDefinition FORMAT = FormatSettingsDefinition.DEF_HEX;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{FORMAT};
    private final boolean signed;

    public AbstractLeb128DataType(String name, boolean signed, DataTypeManager dtm) {
        super(null, name, dtm);
        this.signed = signed;
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        int n;
        block9: {
            if (maxLength < 0) {
                maxLength = 10;
            }
            InputStream is = buf.getInputStream(0, maxLength);
            try {
                n = LEB128.getLength(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return -1;
                }
            }
            is.close();
        }
        return n;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Scalar.class;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int maxLength) {
        long val;
        int len;
        if (maxLength < 0) {
            maxLength = 10;
        }
        if ((len = this.getLength(buf, maxLength)) < 1) {
            return null;
        }
        try (InputStream is = buf.getInputStream(0, maxLength);){
            val = LEB128.read(is, this.signed);
        }
        catch (IOException e) {
            return null;
        }
        int bitLength = Math.min(64, len * 7);
        int mod = bitLength % 8;
        if (mod != 0) {
            bitLength += 8 - mod;
        }
        return new Scalar(bitLength, val, this.signed);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Scalar val = (Scalar)this.getValue(buf, settings, length);
        if (val == null) {
            return "??";
        }
        int radix = FORMAT.getRadix(settings);
        String postfix = FORMAT.getRepresentationPostfix(settings);
        String valStr = val.toString(radix, false, this.signed, "", "");
        return valStr.toUpperCase() + postfix;
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }

    @Override
    public boolean canSpecifyLength() {
        return true;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.name;
    }
}

