/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.AssertException;

public class ParserWalker {
    private static final int MAX_PARSE_DEPTH = 64;
    private SleighParserContext context;
    private SleighParserContext cross_context;
    private ConstructState point;
    private int depth;
    private int[] breadcrumb;

    public ParserWalker(SleighParserContext c) {
        this.context = c;
        this.cross_context = null;
        this.breadcrumb = new int[65];
    }

    public ParserWalker(SleighParserContext c, SleighParserContext cross) {
        this(c);
        this.cross_context = cross;
    }

    public SleighParserContext getParserContext() {
        return this.context;
    }

    public void baseState() {
        this.point = this.context.getRootState();
        this.depth = 0;
        this.breadcrumb[0] = 0;
    }

    public void subTreeState(ConstructState subtree) {
        this.point = subtree;
        this.depth = 0;
        this.breadcrumb[0] = 0;
    }

    public void snippetState() {
        this.point = new ConstructState(null);
        this.depth = 0;
        this.breadcrumb[0] = 0;
    }

    public boolean isState() {
        return this.point != null;
    }

    public ConstructState getState() {
        return this.point;
    }

    public void pushOperand(int i) {
        if (this.depth == 64) {
            throw new AssertException("Exceeded maximum parse depth");
        }
        this.breadcrumb[this.depth++] = i + 1;
        this.point = this.point.getSubState(i);
        this.breadcrumb[this.depth] = 0;
    }

    public void allocateOperand() throws UnknownInstructionException {
        if (this.depth == 64) {
            throw new UnknownInstructionException("Exceeded maximum parse depth");
        }
        ConstructState opstate = new ConstructState(this.point);
        int n = this.depth++;
        this.breadcrumb[n] = this.breadcrumb[n] + 1;
        this.point = opstate;
        this.breadcrumb[this.depth] = 0;
    }

    public void popOperand() {
        this.point = this.point.getParent();
        --this.depth;
    }

    public int getOperand() {
        return this.breadcrumb[this.depth];
    }

    public FixedHandle getFixedHandle(int i) {
        return this.context.getFixedHandle(this.point.getSubState(i));
    }

    public FixedHandle getParentHandle() {
        return this.context.getFixedHandle(this.point);
    }

    public int getOffset(int i) {
        if (i < 0) {
            return this.point.getOffset();
        }
        ConstructState op = this.point.getSubState(i);
        return op.getOffset() + op.getLength();
    }

    public void setOffset(int off) {
        this.point.setOffset(off);
    }

    public int getCurrentLength() {
        return this.point.getLength();
    }

    public void setCurrentLength(int len) {
        this.point.setLength(len);
    }

    public void calcCurrentLength(int minLength, int numopers) {
        minLength += this.point.getOffset();
        for (int i = 0; i < numopers; ++i) {
            ConstructState subpoint = this.point.getSubState(i);
            int sublength = subpoint.getLength() + subpoint.getOffset();
            if (sublength <= minLength) continue;
            minLength = sublength;
        }
        this.point.setLength(minLength - this.point.getOffset());
    }

    public Constructor getConstructor() {
        return this.point.getConstructor();
    }

    public void setConstructor(Constructor ct) {
        this.point.setConstructor(ct);
    }

    public Address getAddr() {
        if (this.cross_context != null) {
            return this.cross_context.getAddr();
        }
        return this.context.getAddr();
    }

    public Address getNaddr() {
        if (this.cross_context != null) {
            return this.cross_context.getNaddr();
        }
        return this.context.getNaddr();
    }

    public Address getN2addr() {
        if (this.cross_context != null) {
            return this.cross_context.getN2addr();
        }
        return this.context.getN2addr();
    }

    public AddressSpace getCurSpace() {
        return this.context.getCurSpace();
    }

    public AddressSpace getConstSpace() {
        return this.context.getConstSpace();
    }

    public Address getFlowRefAddr() {
        return this.context.getFlowRefAddr();
    }

    public Address getFlowDestAddr() {
        return this.context.getFlowDestAddr();
    }

    public int getInstructionBytes(int byteoff, int numbytes) throws MemoryAccessException {
        return this.context.getInstructionBytes(this.point.getOffset(), byteoff, numbytes);
    }

    public int getContextBytes(int byteoff, int numbytes) {
        return this.context.getContextBytes(byteoff, numbytes);
    }

    public int getInstructionBits(int startbit, int size) throws MemoryAccessException {
        return this.context.getInstructionBits(this.point.getOffset(), startbit, size);
    }

    public int getContextBits(int startbit, int size) {
        return this.context.getContextBits(startbit, size);
    }

    public void setOutOfBandState(Constructor ct, int index, ConstructState tempstate, ParserWalker otherwalker) {
        ConstructState pt = otherwalker.point;
        int curdepth = otherwalker.depth;
        while (pt.getConstructor() != ct) {
            if (curdepth <= 0) {
                return;
            }
            --curdepth;
            pt = pt.getParent();
        }
        OperandSymbol sym = ct.getOperand(index);
        int i = sym.getOffsetBase();
        if (i < 0) {
            tempstate.setOffset(pt.getOffset() + sym.getRelativeOffset());
        } else {
            tempstate.setOffset(pt.getSubState(index).getOffset());
        }
        tempstate.setConstructor(ct);
        tempstate.setLength(pt.getLength());
        this.point = tempstate;
        this.depth = 0;
        this.breadcrumb[0] = 0;
    }

    public String getCurrentSubtableName() {
        int curindex;
        if (this.point == null) {
            return null;
        }
        ConstructState parent = this.point.getParent();
        if (parent == null) {
            return null;
        }
        Constructor ct = parent.getConstructor();
        OperandSymbol operand = ct.getOperand(curindex = this.breadcrumb[this.depth - 1] - 1);
        TripleSymbol sym = operand.getDefiningSymbol();
        if (sym instanceof SubtableSymbol) {
            return sym.getName();
        }
        return null;
    }
}

