/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Type;
import ghidra.app.util.bin.format.pdb2.pdbreader.ParsingIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.NoSuchElementException;

public class C13SectionIterator<T extends C13Section>
implements ParsingIterator<T> {
    private PdbByteReader reader;
    private Class<T> clazz;
    private boolean processIgnore;
    private TaskMonitor monitor;
    private C13Type requestedType;
    private C13Type detectedType;
    private T currentSection = null;

    public C13SectionIterator(PdbByteReader reader, Class<T> clazz, boolean processIgnore, TaskMonitor monitor) throws CancelledException {
        this.reader = reader;
        this.clazz = clazz;
        this.requestedType = C13Type.fromClassValue(clazz);
        this.processIgnore = processIgnore;
        this.monitor = monitor;
    }

    @Override
    public boolean hasNext() throws CancelledException {
        if (this.currentSection == null) {
            this.find();
        }
        return this.currentSection != null;
    }

    @Override
    public T next() throws CancelledException, NoSuchElementException {
        if (this.hasNext()) {
            T returnSection = this.currentSection;
            this.currentSection = null;
            return returnSection;
        }
        throw new NoSuchElementException("next() called with no more elements");
    }

    @Override
    public T peek() throws CancelledException, NoSuchElementException {
        if (this.hasNext()) {
            return this.currentSection;
        }
        throw new NoSuchElementException("peek() called with no more elements");
    }

    private void find() throws CancelledException {
        try {
            this.currentSection = this.findAndParse();
        }
        catch (PdbException e) {
            Msg.error((Object)this, (Object)"Problem seen in find()", (Throwable)e);
            this.currentSection = null;
        }
    }

    public T findAndParse() throws CancelledException, PdbException {
        while (this.reader.hasMore()) {
            this.monitor.checkCancelled();
            int index = this.reader.getIndex();
            int typeVal = this.reader.parseInt();
            boolean ignore = C13Type.ignore(typeVal);
            this.detectedType = C13Type.fromValue(typeVal);
            int len = this.reader.parseInt();
            if (!(ignore && !this.processIgnore || this.requestedType != C13Type.ALL && this.detectedType != this.requestedType)) {
                this.reader.setIndex(index);
                C13Section parsedSection = C13Section.parse(this.reader, this.monitor);
                return (T)(parsedSection.getClass().equals(this.clazz) || C13Section.class.equals(this.clazz) ? (C13Section)this.clazz.cast(parsedSection) : null);
            }
            this.reader.skip(len);
        }
        return null;
    }
}

