/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4ExtentHeader
implements StructConverter {
    private static final int SIZEOF = 12;
    private short eh_magic;
    private short eh_entries;
    private short eh_max;
    private short eh_depth;
    private int eh_generation;

    public static Ext4ExtentHeader read(BinaryReader reader) throws IOException {
        if (reader.getPointerIndex() + 12L >= reader.length() || Short.toUnsignedInt(reader.peekNextShort()) != 62218) {
            return null;
        }
        return new Ext4ExtentHeader(reader);
    }

    public Ext4ExtentHeader(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4ExtentHeader(BinaryReader reader) throws IOException {
        this.eh_magic = reader.readNextShort();
        this.eh_entries = reader.readNextShort();
        this.eh_max = reader.readNextShort();
        this.eh_depth = reader.readNextShort();
        this.eh_generation = reader.readNextInt();
    }

    public short getEh_magic() {
        return this.eh_magic;
    }

    public short getEh_entries() {
        return this.eh_entries;
    }

    public short getEh_max() {
        return this.eh_max;
    }

    public short getEh_depth() {
        return this.eh_depth;
    }

    public int getEh_generation() {
        return this.eh_generation;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_extent_header", 0);
        structure.add(WORD, "eh_magic", null);
        structure.add(WORD, "eh_entries", null);
        structure.add(WORD, "eh_max", null);
        structure.add(WORD, "eh_depth", null);
        structure.add(DWORD, "eh_generation", null);
        return structure;
    }
}

