/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;

public class CramFsBlock {
    private int blockPointer;
    private int startAddress;
    private boolean isDirectPointer;
    private boolean isCompressed;
    private int blockSize;
    private ByteProvider provider;
    static final int IS_DIRECT_POINTER = 0x40000000;
    static final int IS_UNCOMPRESSED = Integer.MIN_VALUE;

    public CramFsBlock(int start, int blockSize, ByteProvider provider) {
        this.startAddress = this.blockPointer = start;
        this.blockSize = blockSize;
        this.provider = provider;
        this.isDirectPointer = false;
        this.isCompressed = false;
    }

    public int getBlockPointer() {
        return this.blockPointer;
    }

    public boolean isDirectPointer() {
        return this.isDirectPointer;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public byte[] readBlock() throws IOException {
        return this.provider.readBytes((long)this.startAddress, (long)this.blockSize);
    }
}

