/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.relocs;

import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.reloc.Relocation;
import org.apache.commons.lang3.StringUtils;

public class ExtRelocation
implements IsfObject {
    String name;
    String kind;
    String value;
    String bytes;

    public ExtRelocation(Relocation reloc) {
        String symName;
        this.kind = Integer.toString(reloc.getType());
        this.value = this.pack(reloc.getValues());
        String packedBytes = this.pack(reloc.getBytes());
        if (packedBytes != null) {
            this.bytes = packedBytes;
        }
        if (!StringUtils.isEmpty((CharSequence)(symName = reloc.getSymbolName()))) {
            this.name = reloc.getSymbolName();
        }
    }

    private String pack(long[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (long v : values) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            buf.append("0x" + Long.toHexString(v));
        }
        return buf.toString();
    }

    private String pack(byte[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (byte v : values) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            buf.append("0x" + Integer.toHexString(v & 0xFF));
        }
        return buf.toString();
    }
}

