/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;

public class BSimSearchSettings {
    private double similarity;
    private double confidence;
    private int maxResults;
    private BSimFilterSet filterSet;

    public BSimSearchSettings() {
        this.similarity = 0.7;
        this.confidence = 0.0;
        this.maxResults = 100;
        this.filterSet = new BSimFilterSet();
    }

    public BSimSearchSettings(double similarity, double confidence, int maxResults, BSimFilterSet filterSet) {
        this.similarity = similarity;
        this.confidence = confidence;
        this.maxResults = maxResults;
        this.filterSet = filterSet;
    }

    private BSimSearchSettings(BSimSearchSettings settings) {
        this.similarity = settings.similarity;
        this.confidence = settings.confidence;
        this.maxResults = settings.getMaxResults();
        this.filterSet = settings.getBSimFilterSet().copy();
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public BSimFilterSet getBSimFilterSet() {
        return this.filterSet;
    }

    public BSimSearchSettings copy() {
        return new BSimSearchSettings(this);
    }
}

