/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;

public abstract class FSBNode
extends GTreeSlowLoadingNode {
    protected String name;
    public static final Comparator<GTreeNode> FSBNODE_NAME_TYPE_COMPARATOR = (o1, o2) -> {
        FSBNode node1;
        block5: {
            block4: {
                if (!(o1 instanceof FSBNode)) break block4;
                node1 = (FSBNode)((Object)o1);
                if (o2 instanceof FSBNode) break block5;
            }
            return 0;
        }
        FSBNode node2 = (FSBNode)((Object)o2);
        GFile f1 = node1.getGFile();
        GFile f2 = node2.getGFile();
        int result = Boolean.compare(!f1.isDirectory(), !f2.isDirectory());
        if (result == 0) {
            String n1 = Objects.requireNonNullElse(f1.getName(), "");
            String n2 = Objects.requireNonNullElse(f2.getName(), "");
            result = n1.compareToIgnoreCase(n2);
        }
        return result;
    };

    protected FSBNode(String name) {
        this.name = name;
    }

    public abstract FSRL getFSRL();

    public void init(TaskMonitor monitor) throws CancelledException {
    }

    public GFile getGFile() {
        return null;
    }

    public String getToolTip() {
        return this.getName();
    }

    public Icon getIcon(boolean expanded) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getFileExtension() {
        return FilenameUtils.getExtension((String)this.getName());
    }

    public FSBRootNode getFSBRootNode() {
        for (GTreeNode node = this.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof FSBRootNode)) continue;
            FSBRootNode rootNode = (FSBRootNode)node;
            return rootNode;
        }
        return null;
    }

    public abstract void refreshNode(TaskMonitor var1) throws CancelledException;

    protected void loadChildrenIfNeeded(TaskMonitor monitor) throws CancelledException {
        if (!this.isLeaf() && !this.isLoaded()) {
            this.doSetChildren(this.generateChildren(monitor));
        }
    }

    private static Map<FSRL, GFile> getListing(GFile f) {
        try {
            List<GFile> listing = f.getListing();
            return listing.stream().collect(Collectors.toMap(f1 -> f1.getFSRL(), f1 -> f1));
        }
        catch (IOException e) {
            return Map.of();
        }
    }

    protected void refreshChildren(TaskMonitor monitor) throws CancelledException {
        FSBRootNode fsbRootNode;
        GFile f = this.getGFile();
        if (f == null || !this.isLoaded() || this.isLeaf()) {
            return;
        }
        Map<FSRL, GFile> currentFiles = FSBNode.getListing(f);
        int changeCount = 0;
        boolean cryptoCausesFullRefresh = true;
        boolean flagFSBRootNodeWithCryptoUpdate = false;
        ArrayList<FSBNode> newNodes = new ArrayList<FSBNode>();
        ArrayList currentChildren = new ArrayList(this.children());
        for (GTreeNode oldNode : currentChildren) {
            monitor.increment();
            if (!(oldNode instanceof FSBNode)) continue;
            FSBNode fsbNode = (FSBNode)oldNode;
            GFile currentFile = currentFiles.get(fsbNode.getFSRL());
            if (this.fileMatchesNode(currentFile, fsbNode)) {
                FSBFileNode fileNode;
                boolean checkPwUpdate = cryptoCausesFullRefresh && fsbNode instanceof FSBFileNode && (fileNode = (FSBFileNode)fsbNode).hasMissingPassword();
                fsbNode.refreshNode(monitor);
                flagFSBRootNodeWithCryptoUpdate |= checkPwUpdate && fsbNode instanceof FSBFileNode && !(fileNode = (FSBFileNode)fsbNode).hasMissingPassword();
                newNodes.add(fsbNode);
                currentFiles.remove(fsbNode.getFSRL());
                continue;
            }
            ++changeCount;
        }
        changeCount += currentFiles.size();
        currentFiles.values().stream().map(f1 -> FSBNode.createNodeFromFile(f1, monitor)).forEach(newNodes::add);
        Collections.sort(newNodes, FSBNODE_NAME_TYPE_COMPARATOR);
        if (flagFSBRootNodeWithCryptoUpdate && (fsbRootNode = this.getFSBRootNode()) != null) {
            fsbRootNode.setCryptoStatusUpdated(true);
        }
        if (changeCount > 0) {
            this.setChildren(newNodes);
        }
    }

    private boolean fileMatchesNode(GFile f, FSBNode node) {
        if (f == null) {
            return false;
        }
        if (node instanceof FSBFileNode) {
            FSBFileNode fileNode = (FSBFileNode)node;
            if (f.isDirectory() != fileNode instanceof FSBDirNode) {
                return false;
            }
        }
        return true;
    }

    protected FSBFileNode findMatchingNode(GFile f, TaskMonitor monitor) throws CancelledException {
        this.loadChildrenIfNeeded(monitor);
        for (GTreeNode treeNode : this.children()) {
            if (!(treeNode instanceof FSBFileNode)) continue;
            FSBFileNode fileNode = (FSBFileNode)treeNode;
            if (!fileNode.file.equals(f)) continue;
            return fileNode;
        }
        return null;
    }

    public String getFormattedTreePath() {
        TreePath treePath = this.getTreePath();
        StringBuilder path = new StringBuilder();
        for (Object pathElement : treePath.getPath()) {
            if (!(pathElement instanceof FSBNode)) continue;
            FSBNode node = (FSBNode)((Object)pathElement);
            if (!path.isEmpty()) {
                path.append("/");
            }
            if (node instanceof FSBRootNode) {
                FSBRootNode rootNode = (FSBRootNode)node;
                FSRL fsContainer = rootNode.getContainer();
                if (fsContainer == null) continue;
                path.append(fsContainer.getName());
                continue;
            }
            path.append(node.getFSRL().getName());
        }
        return path.toString();
    }

    public abstract FSRL getLoadableFSRL();

    public static FSBRootNode findContainingFileSystemFSBRootNode(FSBNode node) {
        GTreeNode parent;
        for (parent = node.getParent(); parent != null && !(parent instanceof FSBRootNode); parent = parent.getParent()) {
        }
        return parent instanceof FSBRootNode ? (FSBRootNode)parent : null;
    }

    public static List<GTreeNode> createNodesFromFileList(List<GFile> files, TaskMonitor monitor) {
        files = new ArrayList<GFile>(files);
        Collections.sort(files, FSUtilities.GFILE_NAME_TYPE_COMPARATOR);
        ArrayList<GTreeNode> nodes = new ArrayList<GTreeNode>(files.size());
        for (GFile child : files) {
            FSBFileNode node = FSBNode.createNodeFromFile(child, monitor);
            nodes.add((GTreeNode)node);
        }
        return nodes;
    }

    public static FSBFileNode createNodeFromFile(GFile file, TaskMonitor monitor) {
        FSBFileNode result = file.isDirectory() ? new FSBDirNode(file) : new FSBFileNode(file);
        result.init(monitor);
        return result;
    }
}

