/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51PublicDef;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Omf51PublicDefsRecord
extends OmfRecord {
    private boolean largeSegmentId;
    private List<Omf51PublicDef> defs = new ArrayList<Omf51PublicDef>();

    public Omf51PublicDefsRecord(BinaryReader reader, boolean largeSegmentId) throws IOException {
        super(reader);
        this.largeSegmentId = largeSegmentId;
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            this.defs.add(new Omf51PublicDef(this.dataReader, this.largeSegmentId));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (Omf51PublicDef def : this.defs) {
            struct.add(this.largeSegmentId ? WORD : BYTE, "seg id", null);
            struct.add(BYTE, "info", null);
            struct.add(WORD, "offset", null);
            struct.add(BYTE, "unused", null);
            struct.add(def.getName().toDataType(), def.getName().getDataTypeSize(), "name", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    public List<Omf51PublicDef> getDefinitions() {
        return this.defs;
    }
}

