/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.ne.ImportedNameTable;
import ghidra.app.util.bin.format.ne.LengthStringSet;
import ghidra.util.Conv;
import java.io.IOException;
import java.util.ArrayList;

public class ModuleReferenceTable {
    private short[] offsets;
    private LengthStringSet[] names;

    ModuleReferenceTable(BinaryReader reader, short index, short count, ImportedNameTable imp) throws IOException {
        LengthStringSet lss;
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(Conv.shortToInt((short)index));
        this.offsets = new short[Conv.shortToInt((short)count)];
        for (short i = 0; i < count; i = (short)(i + 1)) {
            this.offsets[i] = reader.readNextShort();
        }
        ArrayList<LengthStringSet> list = new ArrayList<LengthStringSet>();
        for (int i = 0; i < this.offsets.length && (lss = imp.getNameAt(this.offsets[i])).getLength() != 0; ++i) {
            list.add(lss);
        }
        this.names = new LengthStringSet[list.size()];
        list.toArray(this.names);
        reader.setPointerIndex(oldIndex);
    }

    public LengthStringSet[] getNames() {
        return this.names;
    }

    public short[] getOffsets() {
        return this.offsets;
    }
}

