/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.framework.model.DomainObjectException;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

class SearchTask
extends Task {
    private Searcher textSearcher;
    private Navigatable navigatable;
    private Searcher.TextSearchResult result;
    private boolean isCanceled;
    private Program program;

    SearchTask(Navigatable navigatable, Program program, Searcher textSearcher) {
        super("Searching Program Text", true, true, false);
        this.navigatable = navigatable;
        this.textSearcher = textSearcher;
        this.program = program;
    }

    public void run(TaskMonitor monitor) {
        block3: {
            monitor.setMessage("Searching...");
            if (this.isCanceled) {
                monitor.cancel();
                return;
            }
            monitor.setMessage("Searching...");
            this.textSearcher.setMonitor(monitor);
            try {
                this.result = this.textSearcher.search();
            }
            catch (Exception e) {
                if (e instanceof DomainObjectException) break block3;
                Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Error searching", (Throwable)e);
            }
        }
    }

    Searcher getTextSearcher() {
        return this.textSearcher;
    }

    Navigatable getNavigatable() {
        return this.navigatable;
    }

    Searcher.TextSearchResult getSearchLocation() {
        return this.result;
    }

    public void cancel() {
        super.cancel();
        this.isCanceled = true;
    }

    public Program getProgram() {
        return this.program;
    }
}

