/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.WindowPosition;
import docking.action.KeyBindingData;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.table.GTable;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.bookmark.BookmarkNavigator;
import ghidra.app.plugin.core.bookmark.BookmarkPlugin;
import ghidra.app.plugin.core.bookmark.BookmarkRowObject;
import ghidra.app.plugin.core.bookmark.BookmarkTableModel;
import ghidra.app.plugin.core.bookmark.FilterState;
import ghidra.app.services.GoToService;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class BookmarkProvider
extends ComponentProviderAdapter {
    private static final String BOOKMARK_TYPES_ELEMENT_NAME = "BOOKMARK_TYPES";
    private GhidraTable bookmarkTable;
    private JPanel panel;
    private BookmarkTableModel model;
    private TableModelListener listener;
    private Program program;
    private GhidraThreadedTablePanel<BookmarkRowObject> threadedTablePanel;
    private GhidraTableFilterPanel<BookmarkRowObject> tableFilterPanel;

    BookmarkProvider(PluginTool tool, BookmarkPlugin plugin) {
        super(tool, "Bookmarks", plugin.getName(), ProgramActionContext.class);
        this.setIcon(BookmarkNavigator.NOTE_ICON);
        this.addToToolbar();
        this.setKeyBinding(new KeyBindingData(66, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.model = new BookmarkTableModel(tool, null);
        this.threadedTablePanel = new GhidraThreadedTablePanel<BookmarkRowObject>(this.model);
        this.bookmarkTable = this.threadedTablePanel.getTable();
        this.bookmarkTable.setAutoLookupColumn(1);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)((Object)this.threadedTablePanel), "Center");
        this.panel.add((Component)this.createFilterFieldPanel(), "South");
        this.bookmarkTable.setAccessibleNamePrefix("Bookmarks");
        this.adjustTableColumns();
        this.listener = e -> {
            String subTitle = this.model.isFiltered() ? "(filter matched " + this.bookmarkTable.getRowCount() + " of " + this.model.getKeyCount() + ")" : "(" + this.bookmarkTable.getRowCount() + " bookmarks)";
            this.setSubTitle(subTitle);
            this.contextChanged();
        };
        this.bookmarkTable.getModel().addTableModelListener(this.listener);
        TableColumn column = this.bookmarkTable.getColumn(this.bookmarkTable.getColumnName(1));
        CategoryCellEditor editor = new CategoryCellEditor();
        column.setCellEditor(editor);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setWindowGroup("Core.Bookmarks");
        this.setIntraGroupPosition(WindowPosition.BOTTOM);
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        return new ProgramActionContext((ComponentProvider)this, this.program, (Component)((Object)this.bookmarkTable));
    }

    void setGoToService(GoToService goToService) {
        this.bookmarkTable.installNavigation((ServiceProvider)this.tool);
    }

    private JPanel createFilterFieldPanel() {
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.bookmarkTable), this.model);
        this.tableFilterPanel.setToolTipText("Include bookmarks with Categories or Descriptions containing this text.");
        this.tableFilterPanel.setAccessibleNamePrefix("Bookmarks");
        return this.tableFilterPanel;
    }

    private void adjustTableColumns() {
        this.bookmarkTable.sizeColumnsToFit(-1);
        TableColumn column = this.bookmarkTable.getColumn(this.bookmarkTable.getColumnName(2));
        column.setPreferredWidth(200);
        column = this.bookmarkTable.getColumn(this.bookmarkTable.getColumnName(5));
        column.setPreferredWidth(150);
        column = this.bookmarkTable.getColumn(this.bookmarkTable.getColumnName(1));
        column.setPreferredWidth(90);
        column = this.bookmarkTable.getColumn(this.bookmarkTable.getColumnName(3));
        column.setPreferredWidth(90);
    }

    void dispose() {
        this.bookmarkTable.getModel().removeTableModelListener(this.listener);
        this.bookmarkTable.dispose();
        this.threadedTablePanel.dispose();
        this.tableFilterPanel.dispose();
        this.bookmarkTable = null;
        this.tool = null;
        this.program = null;
        this.model = null;
    }

    void reload() {
        if (this.isVisible()) {
            this.updateTableModel(this.program);
        }
    }

    void bookmarkAdded(Bookmark bookmark) {
        if (this.isVisible()) {
            this.model.bookmarkAdded(bookmark);
        }
    }

    void bookmarkChanged(Bookmark bookmark) {
        if (this.isVisible()) {
            this.model.bookmarkChanged(bookmark);
        }
    }

    void bookmarkRemoved(Bookmark bookmark) {
        if (this.isVisible()) {
            this.model.bookmarkRemoved(bookmark);
        }
    }

    void setProgram(Program program) {
        this.program = program;
        if (program == null) {
            this.updateTableModel(program);
            return;
        }
        if (this.isVisible()) {
            this.updateTableModel(program);
        }
    }

    FilterState getFilterState() {
        return this.model.getFilterState();
    }

    void restoreFilterState(FilterState filterState) {
        this.model.restoreFilterState(filterState);
        this.reload();
    }

    public void readConfigState(SaveState saveState) {
        String[] names = saveState.getStrings(BOOKMARK_TYPES_ELEMENT_NAME, null);
        this.loadBookmarkTypes(names);
        this.contextChanged();
    }

    private void loadBookmarkTypes(String[] names) {
        if (names == null || names.length == 0) {
            return;
        }
        this.hideAllTypes();
        for (String bookmarkType : names) {
            this.showType(bookmarkType);
        }
        this.reload();
    }

    public void writeConfigState(SaveState saveState) {
        Collection<String> allTypes = this.model.getAllTypes();
        ArrayList<String> showingTypes = new ArrayList<String>();
        for (String bookmarkType : allTypes) {
            showingTypes.add(bookmarkType);
        }
        String[] strings = showingTypes.toArray(new String[showingTypes.size()]);
        saveState.putStrings(BOOKMARK_TYPES_ELEMENT_NAME, strings);
    }

    boolean isFiltered() {
        return this.model.isFiltered();
    }

    boolean hasTypeFilterApplied() {
        return this.model.hasTypeFilterApplied();
    }

    void setFilterTypes(List<String> filterTypes) {
        this.hideAllTypes();
        for (String type : filterTypes) {
            this.showType(type);
        }
        this.reload();
        this.tool.setConfigChanged(true);
    }

    void showType(String type) {
        this.model.showType(type);
    }

    boolean isShowingType(String type) {
        return this.model.isShowingType(type);
    }

    void hideAllTypes() {
        this.model.hideAllTypes();
    }

    GTable getBookmarkTable() {
        return this.bookmarkTable;
    }

    public void componentHidden() {
        this.updateTableModel(null);
    }

    public void componentShown() {
        this.updateTableModel(this.program);
    }

    private void updateTableModel(Program newProgram) {
        if (this.model == null) {
            return;
        }
        this.model.reload(newProgram);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("BookmarkPlugin", "Bookmarks");
    }

    public void typeAdded(String type) {
        if (this.isVisible()) {
            this.model.typeAdded();
        }
    }

    void delete() {
        if (this.program == null) {
            return;
        }
        this.cancelEdits();
        int[] rows = this.bookmarkTable.getSelectedRows();
        List rowObjects = this.model.getRowObjects(rows);
        BookmarkRowObjectDeleteCommand cmd = new BookmarkRowObjectDeleteCommand(rowObjects);
        if (rowObjects.size() < 20) {
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        } else {
            this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (DomainObject)this.program);
        }
    }

    private void cancelEdits() {
        if (this.bookmarkTable.isEditing()) {
            this.bookmarkTable.getCellEditor().cancelCellEditing();
        }
    }

    ProgramSelection getBookmarkLocations() {
        return this.bookmarkTable.getProgramSelection();
    }

    public void repaint() {
        this.bookmarkTable.repaint();
    }

    GhidraTable getTable() {
        return this.bookmarkTable;
    }

    private class CategoryCellEditor
    extends DefaultCellEditor {
        private GhidraComboBox<String> comboBox;
        private CategoryComboBoxModel comboModel;

        CategoryCellEditor() {
            super((JComboBox<?>)new GhidraComboBox((ComboBoxModel)new CategoryComboBoxModel()));
            this.comboBox = (GhidraComboBox)this.editorComponent;
            this.comboBox.setEditable(true);
            this.comboModel = (CategoryComboBoxModel)this.comboBox.getModel();
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int viewIndex = table.convertColumnIndexToView(0);
            this.comboModel.refresh((String)table.getValueAt(row, viewIndex));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class BookmarkRowObjectDeleteCommand
    extends BackgroundCommand<Program> {
        private List<BookmarkRowObject> bookmarkList;

        public BookmarkRowObjectDeleteCommand(List<BookmarkRowObject> bookmarkList) {
            super("BookMark Delete", true, true, true);
            this.bookmarkList = bookmarkList;
        }

        public boolean doApplyTo(DomainObject obj, TaskMonitor monitor) {
            monitor.initialize((long)this.bookmarkList.size());
            BookmarkManager mgr = ((Program)obj).getBookmarkManager();
            for (BookmarkRowObject rowObject : this.bookmarkList) {
                Bookmark bookmark = mgr.getBookmark(rowObject.getKey());
                mgr.removeBookmark(bookmark);
                monitor.incrementProgress(1L);
                if (!monitor.isCancelled()) continue;
                break;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean applyTo(Program program, TaskMonitor monitor) {
            boolean wasEabled = program.isSendingEvents();
            try {
                program.setEventsEnabled(false);
                boolean bl = this.doApplyTo((DomainObject)program, monitor);
                return bl;
            }
            finally {
                program.setEventsEnabled(wasEabled);
            }
        }
    }

    private class CategoryComboBoxModel
    extends DefaultComboBoxModel<String> {
        private CategoryComboBoxModel() {
        }

        void refresh(String typeString) {
            this.removeAllElements();
            if (typeString != null) {
                String[] categories;
                BookmarkManager manager = BookmarkProvider.this.program.getBookmarkManager();
                for (String element : categories = manager.getCategories(typeString)) {
                    this.addElement(element);
                }
            }
        }
    }
}

