/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;

public class AddOffsetMemRefCmd
implements Command<Program> {
    private Address fromAddr;
    private Address toAddr;
    private boolean toAddrIsBase;
    private RefType refType;
    private SourceType source;
    private int opIndex;
    private long offset;

    public AddOffsetMemRefCmd(Address fromAddr, Address toAddr, boolean toAddrIsBase, RefType refType, SourceType source, int opIndex, long offset) {
        this.fromAddr = fromAddr;
        this.toAddr = toAddr;
        this.toAddrIsBase = toAddrIsBase;
        this.refType = refType;
        this.source = source;
        this.opIndex = opIndex;
        this.offset = offset;
    }

    public boolean applyTo(Program program) {
        ReferenceManager refMgr = program.getReferenceManager();
        refMgr.addOffsetMemReference(this.fromAddr, this.toAddr, this.toAddrIsBase, this.offset, this.refType, this.source, this.opIndex);
        return true;
    }

    public String getStatusMsg() {
        return "";
    }

    public String getName() {
        return "Add Offset Memory Reference";
    }
}

