/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ApplyFunctionDataTypesCmd
extends BackgroundCommand<Program> {
    private Program program;
    private BookmarkManager bookmarkMgr;
    private List<Category> sourceCategories;
    private AddressSetView addresses;
    private SourceType source;
    private boolean alwaysReplace;
    private boolean createBookmarksEnabled;

    public ApplyFunctionDataTypesCmd(List<DataTypeManager> managers, AddressSetView set, SourceType source, boolean alwaysReplace, boolean createBookmarksEnabled) {
        super("Apply Function Data Types", true, false, false);
        this.sourceCategories = ApplyFunctionDataTypesCmd.getRootCategories(managers);
        this.addresses = set;
        this.source = source;
        this.alwaysReplace = alwaysReplace;
        this.createBookmarksEnabled = createBookmarksEnabled;
    }

    public ApplyFunctionDataTypesCmd(Category sourceCategory, AddressSetView set, SourceType source, boolean alwaysReplace, boolean createBookmarksEnabled) {
        super("Apply Function Data Types", true, false, false);
        this.sourceCategories = List.of(sourceCategory);
        this.addresses = set;
        this.source = source;
        this.alwaysReplace = alwaysReplace;
        this.createBookmarksEnabled = createBookmarksEnabled;
    }

    private static List<Category> getRootCategories(List<DataTypeManager> managers) {
        ArrayList<Category> roots = new ArrayList<Category>();
        for (DataTypeManager dtm : managers) {
            roots.add(dtm.getRootCategory());
        }
        return roots;
    }

    public boolean applyTo(Program p, TaskMonitor monitor) {
        this.program = p;
        this.bookmarkMgr = this.program.getBookmarkManager();
        monitor.setMessage("Applying Function Signatures");
        Map<String, List<Symbol>> symbolMap = this.createSymMap();
        try {
            this.applyFunctionDefinitions(monitor, symbolMap);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return true;
    }

    private Map<String, List<Symbol>> createSymMap() {
        HashMap<String, List<Symbol>> symbolMap = new HashMap<String, List<Symbol>>();
        SymbolTable symbolTable = this.program.getSymbolTable();
        if (this.addresses == null) {
            this.getSymbols(symbolMap, symbolTable.getSymbolIterator());
            this.getSymbols(symbolMap, symbolTable.getExternalSymbols());
        } else {
            this.getSymbols(symbolMap, symbolTable.getSymbols(this.addresses, SymbolType.FUNCTION, true));
            this.getSymbols(symbolMap, symbolTable.getSymbols(this.addresses, SymbolType.LABEL, true));
        }
        return symbolMap;
    }

    private void getSymbols(Map<String, List<Symbol>> symbolMap, SymbolIterator symbols) {
        while (symbols.hasNext()) {
            Symbol sym = symbols.next();
            if (sym.isDynamic() || !sym.isExternal() && this.addresses != null && !this.addresses.contains(sym.getAddress())) continue;
            String name = this.getValidName(sym.getName());
            List<Symbol> list = symbolMap.get(name);
            if (list == null) {
                list = new LinkedList<Symbol>();
                symbolMap.put(name, list);
            }
            list.add(sym);
        }
    }

    private String getValidName(String name) {
        int pos;
        for (pos = name.length() - 1; pos >= 0 && Character.isJavaIdentifierPart(name.charAt(pos)); --pos) {
        }
        String val = name.substring(pos + 1, name.length());
        return val;
    }

    private void applyFunctionDefinitions(TaskMonitor monitor, Map<String, List<Symbol>> symbolMap) throws CancelledException {
        HashMap<String, FunctionDefinition> functionNameMap = new HashMap<String, FunctionDefinition>();
        for (Category cat : this.sourceCategories) {
            this.collectFunctionDefinitions(cat, monitor, functionNameMap);
        }
        monitor.initialize((long)functionNameMap.size());
        for (String functionName : functionNameMap.keySet()) {
            monitor.checkCancelled();
            FunctionDefinition fdef = (FunctionDefinition)functionNameMap.get(functionName);
            this.checkForSymbol(monitor, functionName, fdef, symbolMap, null);
            this.checkForSymbol(monitor, functionName, fdef, symbolMap, "thunk");
            monitor.incrementProgress(1L);
        }
    }

    private void collectFunctionDefinitions(Category cat, TaskMonitor monitor, Map<String, FunctionDefinition> functionNameMap) throws CancelledException {
        monitor.checkCancelled();
        for (DataType dataType : cat.getDataTypes()) {
            monitor.checkCancelled();
            if (!(dataType instanceof FunctionDefinition)) continue;
            FunctionDefinition fdef = (FunctionDefinition)dataType;
            String name = fdef.getName();
            if (functionNameMap.containsKey(name)) {
                FunctionDefinition dupeFdef = functionNameMap.get(name);
                if (fdef.isEquivalent((DataType)dupeFdef)) continue;
                functionNameMap.put(name, null);
                continue;
            }
            functionNameMap.put(name, fdef);
        }
        for (DataType dataType : cat.getCategories()) {
            this.collectFunctionDefinitions((Category)dataType, monitor, functionNameMap);
        }
    }

    private void checkForSymbol(TaskMonitor monitor, String functionName, FunctionDefinition fdef, Map<String, List<Symbol>> symbolMap, String prefix) {
        List<Symbol> symbols = this.lookupSymbol(symbolMap, prefix, functionName);
        if (symbols == null) {
            return;
        }
        for (Symbol symbol : symbols) {
            this.checkDoApplyFunctionDefinition(monitor, functionName, fdef, symbol);
        }
    }

    private void checkDoApplyFunctionDefinition(TaskMonitor monitor, String functionName, FunctionDefinition fdef, Symbol sym) {
        PseudoDisassembler pdis;
        monitor.setMessage("Apply Function Signature '" + functionName + "'");
        Address address = sym.getAddress();
        Function func = this.program.getFunctionManager().getFunctionAt(address);
        if (func != null) {
            if (func.isThunk() || func.getSignature(true).equals((Object)fdef)) {
                return;
            }
            SourceType mostTrusted = this.getMostTrustedParameterSource(func);
            if (this.alwaysReplace || !this.source.isLowerPriorityThan(mostTrusted)) {
                this.applyFunction(sym, fdef);
            }
            return;
        }
        func = this.program.getFunctionManager().getFunctionContaining(address);
        if (func != null) {
            return;
        }
        if (!this.isValidFunctionStart(monitor, address)) {
            return;
        }
        CreateFunctionCmd functionCmd = new CreateFunctionCmd(address);
        Listing listing = this.program.getListing();
        if (sym.isExternal() || listing.getInstructionAt(address) != null) {
            functionCmd.applyTo((DomainObject)this.program);
            this.applyFunction(sym, fdef);
            return;
        }
        MemoryBlock block = this.program.getMemory().getBlock(address);
        if (block != null && !block.isInitialized()) {
            return;
        }
        if (listing.getUndefinedDataAt(address) != null && (pdis = new PseudoDisassembler(this.program)).isValidSubroutine(address)) {
            DisassembleCommand disassembleCmd = new DisassembleCommand(address, null, true);
            disassembleCmd.applyTo((DomainObject)this.program);
            functionCmd.applyTo((DomainObject)this.program);
            this.applyFunction(sym, fdef);
        }
    }

    boolean isValidFunctionStart(TaskMonitor monitor, Address address) {
        Instruction instrBefore = this.getInstructionBefore(address);
        if (instrBefore != null && address.equals((Object)instrBefore.getFallThrough())) {
            return false;
        }
        ReferenceIterator referencesTo = this.program.getReferenceManager().getReferencesTo(address);
        for (Reference reference : referencesTo) {
            RefType referenceType = reference.getReferenceType();
            if (referenceType.isCall() || !referenceType.isJump()) continue;
            return false;
        }
        return true;
    }

    Instruction getInstructionBefore(Address address) {
        Address addrBefore = address.previous();
        Instruction instrBefore = null;
        while (addrBefore != null && (instrBefore = this.program.getListing().getInstructionContaining(addrBefore)) != null && instrBefore.isInDelaySlot()) {
            addrBefore = instrBefore.getMinAddress().previous();
        }
        return instrBefore;
    }

    private void applyFunction(Symbol sym, FunctionDefinition fdef) {
        if (fdef == null) {
            Msg.info((Object)((Object)this), (Object)("Multiple function definitions for " + sym.getName() + " at " + String.valueOf(sym.getAddress()) + " found.  No function signature applied."));
            if (this.createBookmarksEnabled) {
                this.bookmarkMgr.setBookmark(sym.getAddress(), "Analysis", "Multiple Function Signatures", "Found multiple function definitions for: " + sym.getName());
            }
            return;
        }
        ApplyFunctionSignatureCmd fsigCmd = new ApplyFunctionSignatureCmd(sym.getAddress(), (FunctionSignature)fdef, this.source);
        fsigCmd.applyTo((DomainObject)this.program);
    }

    private SourceType getMostTrustedParameterSource(Function func) {
        Parameter[] parameters;
        SourceType highestSource = func.getSignatureSource();
        for (Parameter parameter : parameters = func.getParameters()) {
            SourceType paramSource = parameter.getSource();
            if (!paramSource.isHigherPriorityThan(highestSource)) continue;
            highestSource = paramSource;
        }
        return highestSource;
    }

    private List<Symbol> lookupSymbol(Map<String, List<Symbol>> symbolMap, String prefix, String functionName) {
        List<Symbol> symbols;
        if (functionName == null || functionName.length() == 0) {
            return null;
        }
        Object loolupName = functionName;
        if (prefix != null) {
            loolupName = prefix + functionName;
        }
        if ((symbols = symbolMap.get(loolupName)) != null) {
            return symbols;
        }
        symbols = symbolMap.get("_" + (String)loolupName);
        return symbols;
    }
}

