/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class Hcs12DisassembleCommand
extends DisassembleCommand {
    private boolean xgMode;

    public Hcs12DisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet, boolean xgMode) {
        super("Disassemble " + (xgMode ? "XGate" : "HCS12"), startSet, restrictedSet, true);
        this.xgMode = xgMode;
    }

    public Hcs12DisassembleCommand(Address start, AddressSetView restrictedSet, boolean xgMode) {
        this((AddressSetView)new AddressSet(start, start), restrictedSet, xgMode);
        this.useDefaultRepeatPatternBehavior = true;
    }

    @Override
    public void setSeedContext(DisassemblerContextImpl seedContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialContext(RegisterValue initialContextValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean applyTo(Program program, TaskMonitor monitor) {
        this.disassemblyPerformed = false;
        this.unalignedStart = false;
        Register xgmodeReg = program.getProgramContext().getRegister("XGATE");
        RegisterValue xgmodeValue = null;
        if (xgmodeReg == null) {
            if (this.xgMode) {
                return false;
            }
        } else {
            xgmodeValue = new RegisterValue(xgmodeReg, BigInteger.valueOf(this.xgMode ? 1L : 0L));
            super.setInitialContext(xgmodeValue);
        }
        int alignment = 1;
        try {
            if (this.startSet != null) {
                AddressSet alignedSet = new AddressSet();
                for (AddressRange range : this.startSet) {
                    Address max;
                    long maxOffset;
                    Address min = range.getMinAddress();
                    long minOfffset = min.getOffset();
                    if (minOfffset != min.getOffset()) {
                        min = min.getNewAddress(minOfffset);
                    }
                    if ((maxOffset = (max = range.getMaxAddress()).getOffset()) < minOfffset) continue;
                    if (maxOffset != max.getOffset()) {
                        max = max.getNewAddress(maxOffset);
                    }
                    alignedSet.addRange(min, max);
                }
                if (alignedSet.isEmpty()) {
                    this.unalignedStart = true;
                    return false;
                }
                this.startSet = program.getListing().getUndefinedRanges((AddressSetView)alignedSet, true, monitor);
                if (this.startSet.isEmpty()) {
                    return true;
                }
            }
        }
        catch (CancelledException e) {
            return true;
        }
        return this.doDisassembly(monitor, program, alignment);
    }
}

