/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.HWBColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HWBColorImpl;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.dom.DOMException;

public class HWBColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.HWBColorValue {
    private static final long serialVersionUID = 1L;
    private final HWBColorImpl hwbColor;

    public HWBColorValue() {
        this(new HWBColorImpl());
    }

    HWBColorValue(HWBColorImpl color) {
        this.hwbColor = color;
    }

    HWBColorValue(HWBColorValue copied) {
        super(copied);
        this.hwbColor = copied.hwbColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HWB;
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        HWBColorImpl setfrom = ((HWBColorValue)value).hwbColor;
        this.hwbColor.setHue(setfrom.getHue());
        this.hwbColor.setWhiteness(setfrom.getWhiteness());
        this.hwbColor.setBlackness(setfrom.getBlackness());
        this.hwbColor.alpha = setfrom.alpha;
    }

    @Override
    public String getCssText() {
        return this.hwbColor.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        String rgbCss;
        String css = this.hwbColor.toMinifiedString();
        if (!this.hwbColor.isNonOpaque() && this.hasConvertibleComponents() && (rgbCss = ((ColorValue.CSSRGBColor)this.toRGBColor()).toMinifiedString()).length() < css.length()) {
            css = rgbCss;
        }
        return css;
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.hwbColor.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.hwbColor.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.hwbColor.hasConvertibleComponents();
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        double[] rgb = this.hwbColor.toSRGB(false);
        ColorValue.CSSRGBColor color = new ColorValue.CSSRGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.hwbColor.alpha.clone());
        return color;
    }

    @Override
    public HWBColor getColor() {
        return this.hwbColor;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.hwbColor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof HWBColorValue)) {
            return false;
        }
        HWBColorValue other = (HWBColorValue)obj;
        return this.hwbColor.equals(other.hwbColor);
    }

    @Override
    public HWBColorValue clone() {
        return new HWBColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(HWBColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.HWBCOLOR) {
                    throw new DOMException(13, "No hwb() value: " + lunit.toString());
                }
                this.setLexicalHWB(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMException(12, "Bad value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexicalHWB(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            PrimitiveValue primihue = factory.createCSSPrimitiveValue(lu, true);
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primiwhite = factory.createCSSPrimitiveValue(lu, true);
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primiblackness = factory.createCSSPrimitiveValue(lu, true);
            lu = lu.getNextLexicalUnit();
            PrimitiveValue alpha = null;
            if (lu != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lunit.toString());
                }
                lu = lu.getNextLexicalUnit();
                alpha = factory.createCSSPrimitiveValue(lu, true);
                HWBColorValue.this.hwbColor.setAlpha(alpha);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    throw new DOMException(12, "Bad value: " + lunit.toString());
                }
            }
            HWBColorValue.this.hwbColor.setHue(primihue);
            HWBColorValue.this.hwbColor.setWhiteness(primiwhite);
            HWBColorValue.this.hwbColor.setBlackness(primiblackness);
        }
    }
}

