/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.PackageMatcher;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CodeAttributeMatcher {
    public static final CodeAttributeMatcher IGNORING_ALL = new CodeAttributeMatcher(Collections.emptyList());
    private final List<PackageMatcher> matchers;
    private final List<String> patterns;

    public CodeAttributeMatcher(List<String> patterns) {
        this.patterns = patterns;
        this.matchers = patterns.stream().map(s -> s.startsWith("..") ? s : ".." + s).map(s -> s.endsWith("()") ? s.substring(0, s.length() - 2) : s).map(PackageMatcher::of).collect(Collectors.toList());
    }

    public boolean matches(JavaAnnotation<?> annotation, String key) {
        if (this.isEmpty()) {
            return false;
        }
        String annotationName = annotation.getType().getName().replace('$', '.');
        String annotationNameWithMethod = annotationName + "." + key;
        return IntStream.range(0, this.patterns.size()).anyMatch(i -> this.matchers.get(i).matches(this.patterns.get(i).endsWith("()") ? annotationNameWithMethod : annotationName));
    }

    public boolean matches(HasName type) {
        if (this.isEmpty()) {
            return false;
        }
        String annotationName = type.getName().replace('$', '.');
        return IntStream.range(0, this.patterns.size()).anyMatch(i -> !this.patterns.get(i).endsWith("()") && this.matchers.get(i).matches(annotationName));
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.patterns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeAttributeMatcher other = (CodeAttributeMatcher)obj;
        return Objects.equals(this.patterns, other.patterns);
    }
}

