/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.weakassociations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Inflection;
import us.fatehi.utility.Multimap;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

final class PrefixMatches {
    private static final Logger LOGGER = Logger.getLogger(PrefixMatches.class.getName());
    private static final int MAX_TOP_PREFIXES = 12;
    private static final double MIN_SHARED_PREFIX_RATIO = 0.5;
    private final String keySeparator;
    private final Multimap<String, String> keyPrefixes;

    PrefixMatches(List<String> keys, String keySeparator) {
        this.keySeparator = Objects.requireNonNull(keySeparator, "No key separator provided");
        this.keyPrefixes = new Multimap();
        this.analyze(keys);
    }

    public List<String> get(String key) {
        if (this.keyPrefixes.containsKey(key)) {
            return (List)this.keyPrefixes.get(key);
        }
        return Arrays.asList(key);
    }

    public String toString() {
        return this.keyPrefixes.toString();
    }

    private void analyze(List<String> keys) {
        if (keys.isEmpty()) {
            return;
        }
        Collection<String> prefixes = this.findPrefixes(keys);
        this.mapPrefixes(keys, prefixes);
        LOGGER.log(Level.FINE, new StringFormat("Key prefixes=%s", prefixes));
        LOGGER.log(Level.FINE, new StringFormat("Key matches map: %s", new ObjectToStringFormat(this.keyPrefixes)));
    }

    private Map<String, Integer> countPrefixKeyOccurrences(List<String> keys) {
        TreeMap<String, Integer> prefixKeyCounts = new TreeMap<String, Integer>();
        for (String key : keys) {
            String[] splitKey = CollectionsUtility.splitList(key, this.keySeparator);
            if (splitKey == null || splitKey.length <= 1) continue;
            StringBuilder buffer = new StringBuilder(1024);
            for (String token : splitKey) {
                buffer.append(token).append(this.keySeparator);
                String prefix = buffer.toString();
                int prevCount = prefixKeyCounts.getOrDefault(prefix, 0);
                prefixKeyCounts.put(prefix, prevCount + 1);
            }
        }
        return prefixKeyCounts;
    }

    private Collection<String> findPrefixes(List<String> keys) {
        Map<String, Integer> prefixKeyCounts = this.countPrefixKeyOccurrences(keys);
        ArrayList<Map.Entry<String, Integer>> prefixesList = new ArrayList<Map.Entry<String, Integer>>(prefixKeyCounts.entrySet());
        Collections.sort(prefixesList, Comparator.comparing(Map.Entry::getValue));
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int i = 0; i < prefixesList.size(); ++i) {
            boolean isWidelyUsed;
            boolean isTopPrefix = i < 12;
            boolean bl = isWidelyUsed = (double)((Integer)((Map.Entry)prefixesList.get(i)).getValue()).intValue() > (double)prefixKeyCounts.size() * 0.5;
            if (!isTopPrefix && !isWidelyUsed) continue;
            prefixes.add((String)((Map.Entry)prefixesList.get(i)).getKey());
        }
        prefixes.add("");
        return prefixes;
    }

    private void mapPrefixes(List<String> keys, Collection<String> prefixes) {
        for (String key : keys) {
            for (String prefix : prefixes) {
                String matchKeyName = key.toLowerCase();
                if (!matchKeyName.startsWith(prefix)) continue;
                matchKeyName = matchKeyName.substring(prefix.length());
                if (Utility.isBlank(matchKeyName = Inflection.singularize(matchKeyName))) continue;
                this.keyPrefixes.add(key, matchKeyName);
            }
        }
    }
}

