/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.ssl.BaseX509KeyManager;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PEMKeyManager
extends BaseX509KeyManager {
    private final String keyFilePath;
    private final String certFilePath;
    private final String keyAlgorithm;

    public PEMKeyManager(String pemKeyPath, String pemCertsPath, String keyAlgorithm) {
        this.keyFilePath = pemKeyPath;
        this.certFilePath = pemCertsPath;
        this.keyAlgorithm = keyAlgorithm;
    }

    @Override
    public @Nullable PrivateKey getPrivateKey(String s) {
        try {
            Path keyPath = Paths.get(this.keyFilePath, new String[0]);
            PEMKeyManager.validateKeyFilePermissions(keyPath);
            List<String> lines = Files.readAllLines(keyPath);
            StringBuilder keyContent = new StringBuilder();
            for (String line : lines) {
                if (line.contains("BEGIN PRIVATE KEY")) continue;
                if (line.contains("END PRIVATE KEY")) break;
                keyContent.append(line.trim());
            }
            byte[] privateKeyDERBytes = Base64.getDecoder().decode(keyContent.toString());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyDERBytes);
            KeyFactory kf = KeyFactory.getInstance(this.keyAlgorithm);
            Arrays.fill(privateKeyDERBytes, (byte)0);
            for (int i = 0; i < keyContent.length(); ++i) {
                keyContent.setCharAt(i, '\u0000');
            }
            return kf.generatePrivate(keySpec);
        }
        catch (Exception e) {
            this.error = new PSQLException(GT.tr("Could not load the private key", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            return null;
        }
    }

    @Override
    public X509Certificate @Nullable [] getCertificateChain(String alias) {
        X509Certificate[] x509CertificateArray;
        block9: {
            InputStream inStream = Files.newInputStream(Paths.get(this.certFilePath, new String[0]), new OpenOption[0]);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certs = cf.generateCertificates(inStream);
                ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                for (Certificate certificate : certs) {
                    if (!(certificate instanceof X509Certificate)) continue;
                    certChain.add((X509Certificate)certificate);
                }
                x509CertificateArray = certChain.toArray(new X509Certificate[0]);
                if (inStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.error = new PSQLException(GT.tr("Could not load cert chain", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)e);
                    return null;
                }
            }
            inStream.close();
        }
        return x509CertificateArray;
    }
}

