/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;

public class RegExpFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<RegExpFunction> {
    public static final RegExpFunctionBuiltins BUILTINS = new RegExpFunctionBuiltins();

    protected RegExpFunctionBuiltins() {
        super(JSRegExp.CLASS_NAME, RegExpFunction.class);
    }

    public static enum RegExpFunction implements BuiltinEnum<RegExpFunction>
    {
        escape;


        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public int getECMAScriptVersion() {
            return 16;
        }

        @Override
        public Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
            return RegExpFunctionBuiltinsFactory.JSRegExpEscapeNodeGen.create(context, builtin, this.args().fixedArgs(1).createArgumentNodes(context));
        }
    }

    static abstract class JSRegExpEscapeNode
    extends JSBuiltinNode {
        JSRegExpEscapeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        TruffleString escapeString(TruffleString input, @Cached(parameters={"getContext().getStringLengthLimit()"}) StringBuilderProfile builderProfile, @Cached TruffleString.ByteLengthOfCodePointNode lengthOfCodePointNode, @Cached TruffleString.CodePointAtByteIndexNode codePointAtNode, @Cached TruffleString.ReadCharUTF16Node readCharNode, @Cached TruffleString.ByteIndexOfCodePointNode indexOfCodePointNode, @Cached TruffleStringBuilder.AppendJavaStringUTF16Node appendJavaStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            int length = Strings.length(input);
            int initialCapacity = Math.min(Math.max(length + 16, length + (length >> 1)), this.getContext().getStringLengthLimit());
            TruffleStringBuilderUTF16 escaped = builderProfile.newStringBuilder(initialCapacity);
            for (int index = 0; index < length; index += Strings.lengthOfCodePointAt(lengthOfCodePointNode, input, index)) {
                int cp = Strings.codePointAt(codePointAtNode, input, index);
                if (StringBuilderProfile.length(escaped) == 0 && (cp >= 48 && cp <= 57 || cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90)) {
                    builderProfile.append(appendJavaStringNode, escaped, "\\x");
                    builderProfile.append(appendJavaStringNode, escaped, Boundaries.integerToString(cp, 16));
                    continue;
                }
                if (Strings.indexOf(indexOfCodePointNode, Strings.REGEXP_SYNTAX_CHARS_WITH_SOLIDUS, cp) >= 0) {
                    builderProfile.append(appendCodePointNode, escaped, 92);
                    builderProfile.append(appendCodePointNode, escaped, cp);
                    continue;
                }
                if (cp == 9) {
                    builderProfile.append(appendJavaStringNode, escaped, "\\t");
                    continue;
                }
                if (cp == 10) {
                    builderProfile.append(appendJavaStringNode, escaped, "\\n");
                    continue;
                }
                if (cp == 11) {
                    builderProfile.append(appendJavaStringNode, escaped, "\\v");
                    continue;
                }
                if (cp == 12) {
                    builderProfile.append(appendJavaStringNode, escaped, "\\f");
                    continue;
                }
                if (cp == 13) {
                    builderProfile.append(appendJavaStringNode, escaped, "\\r");
                    continue;
                }
                if (Strings.indexOf(indexOfCodePointNode, Strings.REGEXP_OTHER_PUNCTUATORS, cp) >= 0 || JSRuntime.isWhiteSpaceOrLineTerminator(cp) || cp >= 55296 && cp <= 57343) {
                    if (cp <= 255) {
                        builderProfile.append(appendJavaStringNode, escaped, "\\x");
                        JSRegExpEscapeNode.leftPad(builderProfile, appendCodePointNode, appendJavaStringNode, escaped, Boundaries.integerToString(cp, 16), 2);
                        continue;
                    }
                    int numCodeUnits = Strings.lengthOfCodePointAt(lengthOfCodePointNode, input, index);
                    for (int i = index; i < index + numCodeUnits; ++i) {
                        char cu = Strings.charAt(readCharNode, input, i);
                        builderProfile.append(appendJavaStringNode, escaped, "\\u");
                        JSRegExpEscapeNode.leftPad(builderProfile, appendCodePointNode, appendJavaStringNode, escaped, Boundaries.integerToString(cu, 16), 4);
                    }
                    continue;
                }
                builderProfile.append(appendCodePointNode, escaped, cp);
            }
            return StringBuilderProfile.toString(toStringNode, escaped);
        }

        private static void leftPad(StringBuilderProfile builderProfile, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.AppendJavaStringUTF16Node appendJavaStringNode, TruffleStringBuilderUTF16 sb, String str, int padSize) {
            int padding = padSize - str.length();
            if (padding > 0) {
                builderProfile.repeat(appendCodePointNode, sb, 48, padding);
            }
            builderProfile.append(appendJavaStringNode, sb, str);
        }

        @Fallback
        TruffleString escapeNotString(Object input) {
            throw Errors.createTypeErrorNotAString(input);
        }
    }
}

