/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.posix;

import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltins;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.object.Shape;

public final class PScandirIterator
extends PythonBuiltinObject {
    final PosixModuleBuiltins.PosixFileHandle path;
    final DirStreamRef ref;

    public PScandirIterator(Object cls, Shape instanceShape, PythonContext context, Object dirStream, PosixModuleBuiltins.PosixFileHandle path, boolean needsRewind) {
        super(cls, instanceShape);
        this.ref = new DirStreamRef(this, dirStream, context.getSharedFinalizer(), needsRewind);
        this.path = path;
    }

    static class DirStreamRef
    extends AsyncHandler.SharedFinalizer.FinalizableReference {
        final boolean needsRewind;

        DirStreamRef(PScandirIterator referent, Object dirStream, AsyncHandler.SharedFinalizer finalizer, boolean needsRewind) {
            super(referent, dirStream, finalizer);
            this.needsRewind = needsRewind;
        }

        @Override
        public AsyncHandler.AsyncAction release() {
            return new ScandirIteratorBuiltins.ReleaseCallback(this);
        }

        void rewindAndClose(PosixSupportLibrary posixLib, Object posixSupport) {
            if (this.isReleased()) {
                return;
            }
            this.markReleased();
            Object dirStream = this.getReference();
            if (this.needsRewind) {
                posixLib.rewinddir(posixSupport, dirStream);
            }
            try {
                posixLib.closedir(posixSupport, dirStream);
            }
            catch (PosixSupportLibrary.PosixException posixException) {
                // empty catch block
            }
        }
    }
}

